package org.kth.dks.planetlab.messages;

import java.io.IOException;

import org.kth.dks.dks_marshal.DKSMessage;

public class KeepAliveMsg extends DKSMessage {
	public static String NAME = "KEEP_ALIVE";

	private long longIp;

	private String hostname;

	private String ip;

	private int port;

	private long id;

	private boolean dc;

	public KeepAliveMsg() {
	}

	public KeepAliveMsg(long longIp, String hostname, String ip, int port,
			long id, boolean dc) {
		this.longIp = longIp;
		this.hostname = hostname;
		this.ip = ip;
		this.port = port;
		this.id = id;
		this.dc = dc;
	}

	public String getName() {
		return NAME;
	}

	public boolean isDc() {
		return dc;
	}

	public String getHostname() {
		return hostname;
	}

	public long getId() {
		return id;
	}

	public String getIp() {
		return ip;
	}

	public long getLongIp() {
		return longIp;
	}

	public int getPort() {
		return port;
	}

	public void marshal() throws IOException {
		marshaler.addLong(longIp, "longIp");
		marshaler.addString(hostname, "hostname");
		marshaler.addString(ip, "ip");
		marshaler.addInt(port, "port");
		marshaler.addLong(id, "id");
		marshaler.addBool(dc, "dc");
	}

	public void unmarshal() throws IOException {
		longIp = marshaler.remLong("longIp");
		hostname = marshaler.remString("hostname");
		ip = marshaler.remString("ip");
		port = marshaler.remInt("port");
		id = marshaler.remLong("id");
		dc = marshaler.remBool("dc");
	}
}
