package org.kth.dks.dks_node;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: KTH-IMIT/SICS</p>
 * @author not attributable
 * @version 1.0
 */

public class Interval {

  public final long start;

  public final long end;

  /**
   * Intervals specified in the format ]] (open interval, closed interval).
   * No consistency checks ever performed (identifiers can be larger than DKSNode.N)
   * @param s long start parameter
   * @param e long end parameter
   */
  public Interval(long s, long e) {
    start = s;
    end = e;
  }

  public String toString() {
    return "[start:" + start + " end:" + end + "]";
  }

  public boolean equals(Object o) {
    if (o==this)
      return true;
    else if (!(o instanceof Interval))
      return false;
    else {
      Interval thisO = (Interval) o;
      return thisO.start==start && thisO.end==end;
    }
  }

  public int hashCode() {
    int tmp=17;
    tmp=37*tmp + (int) (start ^ (start >>> 32));
    tmp=37*tmp + (int) (end ^ (end >>> 32));
    return tmp;
  }
}
