//Hamid:We use this class for managing more than one insertion at the same time.
//We keep all keys and values plus an ID in a hash table. We send this ID with
//all messages and when the hosting node is found, we use this ID to find the
//right value in the hash table. There is also a counter to keep track of how
//many values are waiting to be inserted in the table.

package org.kth.dks.dks_node;

import java.util.Hashtable;

public class InsertManager {
  private Hashtable items = null;
  private long toBeInserted = 0;
  private long ID = 0;
  private long MAXID = Long.MAX_VALUE;

  public InsertManager() {
    items = new Hashtable();
    toBeInserted = 0;
    ID = 0;
  }

  public long add( InsertedItem newItem ) {
    ID++;
    if( ID == MAXID )
      ID = 0;
    items.put( new Long( ID ), newItem );
    toBeInserted++;

    return ID;
  }

  public InsertedItem get( long ID ) {
    if( toBeInserted > 0 )
      toBeInserted--;

    return (InsertedItem)items.remove( new Long( ID ) );
  }

  public boolean iAmInsertingData() {
    return (toBeInserted > 0);
  }
}

class InsertedItem {
  private long key = 0;
  private String value = null;
  private LookupType type = LookupType.INSERT; //0==insert, 1==remove

  public InsertedItem( long k, String v, LookupType t ) {
    key = k;
    value = v;
    type = t;
  }

  long getKey() {
    return key;
  }

  String getValue() {
    return value;
  }

  LookupType getType() {
    return type;
  }
}

