package org.kth.dks.dks_node;

import org.apache.log4j.Logger;
import org.kth.dks.DKSAppInterface;
import org.kth.dks.DKSCallbackInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;

/**
 * This is a default class implementing placeholders for every callback that an application should implement
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: KTH-IMIT/SICS</p>
 * @author not attributable
 * @version 1.0
 */

public class DefaultAppHandler implements DKSAppInterface {
  private Logger log = Logger.getLogger(DefaultAppHandler.class);
  protected DKSCallbackInterface dks;

  public DefaultAppHandler(DKSCallbackInterface dksImpl) {
    dks=dksImpl;
  }

  public DefaultAppHandler() {

  }

  public void setDKSCallbackInterface(DKSCallbackInterface d) {
    dks = d;
  }

  public DKSObject routeCallback(long identifier, DKSObject payload)
  {
    error("routeCallback");
    return new DKSObject(new byte[0]);
  }

  public void routeCallbackAsync(long identifier, DKSObject payload)
  {
    error("routeCallback");
  }

    public void broadcastCallback(DKSObject payload){
	error("broadcastCallback");
    }

    public void joinCallback(DKSRef pred, DKSRef succ)
  {
    error("joinCallback");
    dks.joinCallbackReturn();
  }

  public void leaveCallback(DKSRef pred, DKSRef succ)
  {
    error("leaveCallback");
    dks.leaveCallbackReturn();
  }

  public void failCallback(DKSRef failed, DKSRef failedPred) {
    error("failCallback");

  }

  private void error(String str)
  {
    log.error("No appHandler defined, call setCallbackHandler(). ("+str+")");
  }
}
