package org.kth.dks.dks_marshal;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.kth.dks.util.Future;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSAXParser {
  protected SAXParser saxParser = null;

  public XMLSAXParser( Future xmlFutureBuffer ) {//New
    saxParser = new SAXParser();
    saxParser.setContentHandler( new SAXHandler( this, xmlFutureBuffer ) );
  }

  public void parse( byte [] inputXML ) {
    if( saxParser == null )
      return;
    ByteArrayInputStream bais = new ByteArrayInputStream( inputXML );
    InputSource is = new InputSource( bais );
    try {
      saxParser.parse(is);
    } catch(IOException ex) {
      ex.printStackTrace();
    } catch(SAXException ex) {
      ex.printStackTrace();
    }
  }//Parse

  public static String make( XMLMessage xmlMsg ) {
    String xml = null;

    OutputFormat outputFormat = new OutputFormat("XML","ISO-8859-1",true);

    java.io.StringWriter stringWriter = new java.io.StringWriter();

    XMLSerializer serializer = new XMLSerializer( stringWriter, outputFormat );

    try {
      ContentHandler handler = serializer.asContentHandler();
      handler.startDocument();
      AttributesImpl atts = new AttributesImpl();
      XMLElement xmlElement = null;
      XMLElement xmlElementRoot = null;
      XMLAttribute xmlAttribute = null;
      String data = null;

      //root
      xmlElementRoot = xmlMsg.getElementAt(0);
      data = xmlElementRoot.getData();
      atts.clear();
      for( int j = 0 ; j < xmlElementRoot.getAttributesCount() ; j++ ) {
        xmlAttribute = xmlElementRoot.getAttributeAt(j);
        atts.addAttribute("","",xmlAttribute.getName(),"CDATA",xmlAttribute.getValue());
      }//attributes
      handler.startElement("","",xmlElementRoot.getName(),atts);
      if( data != null )
        handler.characters(data.toCharArray(),0,data.length());

        //other elements
      for( int i = 1 ; i < xmlMsg.size() ; i++ ) {
        xmlElement = xmlMsg.getElementAt(i);
        data = xmlElement.getData();
        atts.clear();
        for( int j = 0 ; j < xmlElement.getAttributesCount() ; j++ ) {
          xmlAttribute = xmlElement.getAttributeAt(j);
          atts.addAttribute("","",xmlAttribute.getName(),"CDATA",xmlAttribute.getValue());
        }//attributes
        handler.startElement("","",xmlElement.getName(),atts);
        if( data != null )
          handler.characters(data.toCharArray(),0,data.length());
        handler.endElement("","",xmlElement.getName());
      }//elements

      handler.endElement("","",xmlElementRoot.getName());//root

      handler.endDocument();
      xml = stringWriter.getBuffer().toString();
    }
    catch (IOException ex) {
      ex.printStackTrace();
      xml = null;
    }
    catch (SAXException ex1) {
      ex1.printStackTrace();
    }

    //DKSPrint.Println("TEST:XML:" + xml);
    return xml;
  }//Make
}//XMLSAXParser class

