package org.kth.dks.dks_marshal;

import java.util.LinkedList;
import java.util.List;

public class XMLElement {
  private String name = null;
  private List attributes = null;
  private String data = null;

  public XMLElement( String newname, String newdata ) {
    name = newname;
    data = newdata;
    attributes = new LinkedList();
  }

  public void setData( String newdata ) {
    data = newdata;
  }

  public void addAttribute( XMLAttribute newattribute ) {
    if( attributes == null )
      attributes = new LinkedList();
    attributes.add( newattribute );
  }

  public String getName() {
    return name;
  }

  public String getData() {
    return data;
  }

  public int getAttributesCount() {
    if( attributes == null )
      return 0;

    return attributes.size();
  }

  public List getAttributes() {
    return attributes;
  }

  public XMLAttribute getAttributeAt( int index ) {
    if( attributes == null )
      return null;

    if( index < 0 || index >= attributes.size() )
      return null;

    return (XMLAttribute) attributes.get( index );
  }
}//XMLElement class
