package org.kth.dks.dks_marshal;

import java.util.Vector;

import org.kth.dks.util.Future;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandler extends DefaultHandler {
  private Vector elements = null;
  private String data = null;
  private XMLSAXParser myParent = null;
  private Future xmlFutureBuffer = null;

  SAXHandler(XMLSAXParser myparent, Future xmlFutureBuffer ) {
    myParent = myparent;
    elements = new Vector();
    this.xmlFutureBuffer = xmlFutureBuffer;
  }

  public void startDocument() throws SAXException {
    //DKSPrint.Println("START DOCUMENT");
    elements.clear();
    data = null;
  }

  public void endDocument() throws SAXException {
    //DKSPrint.Println("END DOCUMENT");

    XMLMessage xmlMsg = new XMLMessage();
    for( int i = 0 ; i < elements.size() ; i++ )
      xmlMsg.addElement( (XMLElement) elements.elementAt(i) );

    //objA.callBack( xmlMsg, myParent );
    xmlFutureBuffer.store( xmlMsg );
  }

  public void startElement(String namespaceURI,
                           String sName, // simple name
                           String qName, // qualified name
                           Attributes attrs) throws SAXException {

    XMLElement xmlElement = new XMLElement( qName, null );
    elements.add( xmlElement );
    data = null;

    if (attrs != null)
      for (int i = 0; i < attrs.getLength(); i++)
      {
        xmlElement.addAttribute( new XMLAttribute( attrs.getQName(i), attrs.getValue(i) ) );
      }
  }//startElement

  public void endElement(String namespaceURI,
                         String sName, // simple name
                         String qName // qualified name
                         ) throws SAXException {
    if( data != null ) {
      for( int i = 0 ; i < elements.size() ; i++ ) {
        XMLElement xmle = (XMLElement) elements.elementAt(i);
        if( xmle.getName().equals(qName) ) {
          xmle.setData(data);
          break;
        }
      }

      data = null;
    }

    //DKSPrint.Println("END_ELM: " + qName);
  }//endElement

  public void characters(char buf[], int offset, int len) throws SAXException {
    data = new String(buf, offset, len);
    //DKSPrint.Println("CHARS: " + data);
  }//characters
}




//Old version!!! 04-06-10
/*
class SAXHandler extends DefaultHandler {
  private Object obj = null;
  private int id = 0;
  private String msg = null;


  //new
  private ConnectionManager cm = null;
  Object myparent = null;
  int newport;
  String newip = null;
  int newid;
  int newguid;
  int newr_guid;

  //ack
  boolean ack = false;
  int ackMsgID = 0;

  SAXHandler( Object newobj, Object parent, ConnectionManager newcm ) {
    this.obj = newobj;
    myparent = parent;
    cm = newcm;
  }

  public void startDocument() throws SAXException {
    DKSPrint.Println("START DOCUMENT");
    id = 0;
    msg = null;

    ack = false;
  }

  public void endDocument() throws SAXException {
    DKSPrint.Println("END DOCUMENT");
    if( obj == null )
      DKSPrint.Println("TEST:SAXHandler:GUI Obj is null.");
    if( msg == null )
      DKSPrint.Println("TEST:SAXHandler:msg is null.");

    if( obj != null && msg != null )
      ((test_bed.TestBed_GUI)obj).ShowMsg( id + ":" + msg );

    if( newip != null ) {
      ( (XMLSAXParser) myparent).newdksref = new DKSRef(newport, newip, newid,
          newguid, newr_guid);
      //( (XMLSAXParser) myparent).myNotify();
      myparent.notify();
      DKSPrint.Println("TEST:SAXHandler:New DKSRef created.");
    }

    if( ack ) {
      DKSPrint.Println("TEST:SAXHAndler:Ack received:msgID:" + ackMsgID);
      cm.getAck( ackMsgID );
    }
  }

  public void startElement(String namespaceURI,
                           String sName, // simple name
                           String qName, // qualified name
                           Attributes attrs) throws SAXException {

    if( qName.equals("DKSMSG") ) {
      if (attrs != null) {
        for (int i = 0; i < attrs.getLength(); i++) {
          String aName = attrs.getQName(i);
          if (aName.equals("msg"))
            msg = attrs.getValue(i);
          else if (aName.equals("dksid"))
            id = Integer.parseInt( attrs.getValue(i) );
        }//for
      }//if
    }//if

    else if( qName.equals("DKSREF") ) {
      if (attrs != null) {
        for (int i = 0; i < attrs.getLength(); i++) {
          String aName = attrs.getQName(i);
          if (aName.equals("ip"))
            newip = attrs.getValue(i);
          else if (aName.equals("port"))
            newport = Integer.parseInt( attrs.getValue(i) );
          else if (aName.equals("id"))
            newid = Integer.parseInt( attrs.getValue(i) );
          else if (aName.equals("guid"))
            newguid = Integer.parseInt( attrs.getValue(i) );
          else if (aName.equals("rguid"))
            newr_guid = Integer.parseInt( attrs.getValue(i) );
        }//for
      }//if
    }//if

    else if( qName.equals("DKSACK") ) {
      ack = true;
      if (attrs != null) {
        for (int i = 0; i < attrs.getLength(); i++) {
          String aName = attrs.getQName(i);
          if (aName.equals("msgid"))
            ackMsgID = Integer.parseInt( attrs.getValue(i) );
          else if (aName.equals("dksid"))
            id = Integer.parseInt( attrs.getValue(i) );
        }//for
      }//if
    }//if

    DKSPrint.Println("ELEMENT: " + qName);
    if (attrs != null)
      for (int i = 0; i < attrs.getLength(); i++)
        DKSPrint.Println(" ATTR: " + attrs.getQName(i) + " VALUE: " + attrs.getValue(i) );
  }//startElement

  public void endElement(String namespaceURI,
                         String sName, // simple name
                         String qName // qualified name
                         ) throws SAXException {
    DKSPrint.Println("END_ELM: " + qName);
  }//endElement

  public void characters(char buf[], int offset, int len) throws SAXException {
    String s = new String(buf, offset, len);
    DKSPrint.Println("CHARS: " + s);
  }//characters
}//SAXHandler class
*/
