package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

public class RestartOperationMsg extends DKSMessage {
  private static String NAME= "RESTARTOPERATION";
  private DKSMessage operation = null;

  public String getName() { return NAME; }
  public DKSMessage getOperation() { return operation; }

  public RestartOperationMsg() {
  }

  public RestartOperationMsg(DKSMessage msg) {

    operation = msg;
  }

  public void marshal() throws IOException {
    marshaler.addByteArray(operation.flatten(), "operation");
  }

  public void unmarshal() throws IOException {
    operation = DKSMessage.unmarshal( marshaler.remByteArray("operation") );
  }
}
