package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.kth.dks.dks_comm.DKSRef;

public class NodeLeftMsg extends DKSMessage { // shouldnt be public!
  private static String NAME = "NODELEFTMSG";
  private DKSRef oldNode;
  private List liveRefs=null;
  private List nonces=null;

  public String getName() {
    return NAME;
  }

  public DKSRef getOldNode() {
    return oldNode;
  }

  public List getLiveRefs() {
    return liveRefs;
  }

  public List getNonces() {
    return nonces;
  }

  public NodeLeftMsg() {

  }

  public NodeLeftMsg(DKSRef oldNode, List liveRefs, List nonces) {

    this.oldNode  = oldNode;
    this.liveRefs = new LinkedList(liveRefs);
    this.nonces   = new LinkedList(nonces);
  }

  public void marshal() throws IOException {
    marshaler.addDKSRef(oldNode, "oldnode");
    marshaler.addDKSRefArray((DKSRef[])liveRefs.toArray(new DKSRef[0]), "liverefs");
    marshaler.addDKSRefArray((DKSRef[])nonces.toArray(new DKSRef[0]), "noncerefs");

  }

  public void unmarshal() throws IOException {
    oldNode  = marshaler.remDKSRef("oldnode");
    liveRefs = new LinkedList(marshaler.remDKSRefArray("liverefs"));
    nonces   = new LinkedList(marshaler.remDKSRefArray("noncerefs"));
  }

}
