package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;

public class JoinInitMsg extends DKSMessage {
  private static String NAME= "JOININIT";
  private DKSRef p;
  private DKSRef []  dArray;

  public String getName() { return NAME; }
  public DKSRef getP() { return p; }
  public DKSRef [] getDKSRefs() { return dArray; }

  public JoinInitMsg() {
  }

  public JoinInitMsg( DKSRef p, DKSRef [] d) {
    this.p = p;
    this.dArray = d;
  }

  public void marshal() throws IOException {
    marshaler.addDKSRef(p, "predref");
    marshaler.addDKSRefArray(dArray, "refarr");

  }

    public void unmarshal() throws IOException {
      p      = marshaler.remDKSRef("predref");
      dArray = (DKSRef [])(marshaler.remDKSRefArray("refarr")).toArray(new DKSRef[0]);
    }

}
