package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

public class HelloMsg extends DKSMessage {
  private static String NAME= "HELLO";
  private String type;

  public String getName() { return NAME; }
  public String getType() { return type; }

  public HelloMsg() {
  }

  public HelloMsg(String type) {
    this.type = type;
  }

  public void marshal() throws IOException {
    marshaler.addString(type, "htype");

  }

  public void unmarshal() throws IOException {
    type = marshaler.remString("htype");
  }
}
