package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_node.Interval;

public class CorrectionOnLeaveMsg extends DKSMessage implements CorrectionOnChangeInterface { // shouldnt be public!
  private static String NAME = "CORRECTIONONLEAVE";
  private DKSRef oldNode;
  private DKSRef newNode;
  private Interval interval;

  public String getName() {
    return NAME;
  }

  public DKSRef getNewNode() {
    return newNode;
  }

  public DKSRef getOldNode() {
    return oldNode;
  }

  public Interval getInterval() {
    return interval;
  }

  public CorrectionOnLeaveMsg() {

  }

  public CorrectionOnLeaveMsg(DKSRef oldNode, DKSRef newNode, Interval i) {

    this.oldNode = oldNode;
    this.newNode = newNode;
    this.interval = i;
  }

  public void marshal() throws IOException {
    marshaler.addDKSRef(newNode, "newnode");
    marshaler.addDKSRef(oldNode, "oldnode");
    marshaler.addLong(interval.start, "intervalstart");
    marshaler.addLong(interval.end, "intervalend");

    /*
    XMLMessage msg = new XMLMessage();

    XMLElement xmlElementRef = new XMLElement(NAME, null);
    XMLAttribute xmlAttr1 = new XMLAttribute("intervalstart",
                                             Long.toString(interval.start));
    XMLAttribute xmlAttr2 = new XMLAttribute("intervalend",
                                             Long.toString(interval.end));
    XMLAttribute xmlAttr3 = new XMLAttribute("oldnode", oldNode.getDKSURL());
    XMLAttribute xmlAttr4 = new XMLAttribute("newnode", newNode.getDKSURL());
    xmlElementRef.addAttribute(xmlAttr1);
    xmlElementRef.addAttribute(xmlAttr2);
    xmlElementRef.addAttribute(xmlAttr3);
    xmlElementRef.addAttribute(xmlAttr4);
    msg.addElement(xmlElementRef);

    return msg;
    */
  }

  public void unmarshal() throws IOException {
    newNode = marshaler.remDKSRef("newnode");
    oldNode = marshaler.remDKSRef("oldnode");
    long s  = marshaler.remLong("intervalstart");
    long e  = marshaler.remLong("intervalend");
    interval = new Interval(s, e);

    /*
    XMLElement xmle = xmlMsg.getElementAt(0);

    long s = 0, e = 0;
    for (int i = 0; i < xmle.getAttributesCount(); i++) {
      XMLAttribute attrs = xmle.getAttributeAt(i);
      String aName = attrs.getName();
      if (aName.equals("intervalstart")) {
        s = Long.parseLong(attrs.getValue());
      }
      else if (aName.equals("intervalend")) {
        e = Long.parseLong(attrs.getValue());
      }
      else if (aName.equals("oldnode")) {
        try {
          oldNode = DKSRef.valueOf( attrs.getValue() );
        }
        catch (Exception ex) {
          ex.printStackTrace();
        }
      }
      else if (aName.equals("newnode")) {
        try {
          newNode = DKSRef.valueOf( attrs.getValue() );
        }
        catch (Exception ex) {
          ex.printStackTrace();
        }
      }
    } //for
    interval = new Interval(s, e);
    */
  }

}
