package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;

public class ByeMsg extends DKSMessage {
  private static String NAME= "BYE";
  private String typeList;
  private DKSRef [] dArray;

  public ByeMsg() {

  }

  public ByeMsg( String typeList, DKSRef [] d ) {

    this.typeList = typeList;
    this.dArray = d;
  }

    public String getName() { return NAME; }
    public String getTypeList() { return typeList; }
    public DKSRef [] getDKSRefs() { return dArray; }

    public void marshal() throws IOException {
      marshaler.addString(typeList, "typelist");
      marshaler.addDKSRefArray(dArray, "refarr");

    }

    public void unmarshal() throws IOException {
      typeList = marshaler.remString("typelist");
      dArray = (DKSRef [])(marshaler.remDKSRefArray("refarr")).toArray(new DKSRef[0]);
    }
}
