package org.kth.dks.dks_marshal;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSNetAddress;

public class BootstrapMsg extends DKSMessage {
  private static String NAME = "BOOT";
  private DKSNetAddress p;

  public BootstrapMsg() {
  }

  public BootstrapMsg(DKSNetAddress p) {

    this.p = p;
  }

  public String getName() {
    return NAME;
  }

  public DKSNetAddress getNetAddress() {
    return p;
  }

  public void marshal() throws IOException {
    marshaler.addDKSNetAddress(p, "ref");

  }

  public void unmarshal() throws IOException {
    p = marshaler.remDKSNetAddress("ref");
  }
}
