package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_marshal.DKSMessage;

public class RetreiveItemsMsg
    extends DKSMessage {
  public final static String NAME = "RETREIVEITEMS";
  private long start;
  private long end;

  public String getName() {
    return NAME;
  }

  public long getStart() {
    return start;
  }

  public long getEnd() {
    return end;
  }

  public RetreiveItemsMsg() {

  }

  public RetreiveItemsMsg(long s, long e) {

    start = s;
    end = e;
  }

  public void marshal() throws IOException {
    marshaler.addLong(start, "start");
    marshaler.addLong(end, "end");

  }

  public void unmarshal() throws IOException {
    start = marshaler.remLong("start");
    end = marshaler.remLong("end");
  }
}
