/**
 * Message sent by the multicast DHT as a reply to join a new
 * multicast group
 */
package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class MCastGroupInfoReplyMsg extends DKSMessage {
    public final static String NAME= "MCASTGROUPINFOREPLYMSG";
    DKSRef[] refs;

    public String getName() { return NAME; }

    public void addRefs(DKSRef[] refs) {
	this.refs = refs;
    }

    public DKSRef[] getRefs() {
	return refs;
    }

    public MCastGroupInfoReplyMsg() {
    }

    public void marshal() throws IOException {
      marshaler.addDKSRefArray(refs, "refs");

   }

    public void unmarshal() throws IOException {
      refs = (DKSRef[])marshaler.remDKSRefArray("refs").toArray(new DKSRef[0]);
    }
}
