package org.kth.dks.dks_dht;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

/**
 *
 * Callbacks from messages received by the DHT but belonging to a
 * higher layer are handled by instances of this interface
 */

public interface DKSDHTCallback {

    /**
     * Receive a broadcast message
     */
    public void dhtBroadcastCallback(DKSObject value);

    /**
     * The callback is called at the responsible node when a route()
     * message reaches its destination and the message is not handled
     * at a lower abstraction layer. It receives a DKSMessage, and
     * returns a possibly new DKSMessage <b>INVARIANT</b>: the
     * implementor of this method SHOULD immediately return, as
     * otherwise the underlying DKSNode cannot process new messagesl,
     * and consequently the method cannot recursively call other
     * methods in the DKSInterface as the DKSNode will not be able to
     * receive response messages. Consider using routeAsync() in
     * DKSInterface.
     * @param identifier long, the identifier searched for in route,
     * maybe not interesting for the app in many cases.
     * @param payload DKSObject, the actual payload sent by the source
     * @return DKSObject the payload to be routed back or null if the
     * message is unhandled
     */
    public DKSMessage dhtRouteCallback(long identifier, DKSMessage value);


    /**
     * The callback is called at the responsible node when a route()
     * message reaches its destination and the message is not handled
     * at a lower abstraction layer. It receives a DKSMessage
     * @param identifier long, the identifier searched for in route,
     * maybe not interesting for the app in many cases.
     * @param payload DKSObject, the actual payload sent by the source
     */
    public void dhtRouteCallbackAsync(long identifier, DKSMessage payload);
   
}
