package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class DHTResultMsg extends DKSMessage {
    public static final String NAME= "DHTRESULTMSG";
    private DKSObject[] payload=new DKSObject[0];
    private long msgId;
    private int result;

    public String getName() { return NAME; }
    public DKSObject[] getPayload(){ return payload;}
    public long getMsgId() {return msgId;}
    public int getResult() {return result;}

    public DHTResultMsg() {
    }

    public DHTResultMsg( long id, int r, DKSObject[] pld) {
      result=r;
      msgId=id;
      payload=pld;
    }

    public DHTResultMsg( long id, int r) {

      result=r;
      msgId=id;
    }


  public void marshal() throws IOException {
    marshaler.addLong(msgId, "id");
    marshaler.addInt(result, "index");
    marshaler.addInt(payload.length, "arrlen");
    for (int i=0; i<payload.length; i++) {
      marshaler.addDKSObject(payload[i], "payload"+(i+1));
    }

  }

  public void unmarshal() throws IOException {
    msgId   = marshaler.remLong("id");
    result  = marshaler.remInt("index");
    int len = marshaler.remInt("arrlen");
    payload = new DKSObject[len];
    for (int i=0; i<len; i++) {
      payload[i] = marshaler.remDKSObject("payload"+(i+1));
    }
 }
}
