package org.kth.dks.dks_dht;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT</p>
 * @author Ali Ghodsi (aligh@kth.se}
 * @version 1.0
 */

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.CorrectionOnChangeInterface;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.Interval;

public class DHTRestoreReplicasMsg extends DKSMessage implements CorrectionOnChangeInterface { // shouldnt be public!
  public static String NAME = "DHTRESTOREREPLICASMSG";
  private DKSRef newNode;
  private Interval interval;

    private int cc;
    private int id; 

    public String getName() {
    return NAME;
    }
    
    public int getCC() {
    return cc;
  }
    public int getId() {
    return id;
    }

  public DKSRef getNewNode() {
    return newNode;
  }

  public Interval getInterval() {
    return interval;
  }

  public DHTRestoreReplicasMsg() {

  }

  public DHTRestoreReplicasMsg(DKSRef newNode, Interval i, int c, int id) {
    this.newNode = newNode;
    this.interval = i;
    this.cc = c;
    this.id = id; 
  }

  public void marshal() throws IOException {
    marshaler.addLong(interval.start, "intervalstart");
    marshaler.addLong(interval.end,"intervalend");
    marshaler.addInt(cc, "cc");
    marshaler.addInt(id, "id");
    marshaler.addDKSRef(newNode, "newnode");

  }


  public void unmarshal() throws IOException {
    long s   = marshaler.remLong("intervalstart");
    long e   = marshaler.remLong("intervalend");
    interval = new Interval(s,e);
    cc       =  marshaler.remInt("cc");
    id      =   marshaler.remInt("id");
    newNode  = marshaler.remDKSRef("newnode");
  }
}
