/**
 * Message sent by the multicast DHT to create a new multicast group
 */
package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_marshal.DKSMessage;

public class CreateMCastGroupReplyMsg extends DKSMessage {
    public final static String NAME= "CREATEMCASTGROUPREPLYMSG";
    boolean success;

    public String getName() { return NAME; }
    public boolean getStatus() { return success; }

    public CreateMCastGroupReplyMsg() {

    }

    public CreateMCastGroupReplyMsg(boolean success) {

      this.success = success;
    }

    public void marshal() throws IOException {
      marshaler.addBool(success, "success");

    }

    public void unmarshal() throws IOException {
      success = marshaler.remBool("success");
    }
}
