/**
 * Message sent by the multicast DHT to create a new multicast group
 */
package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class CreateMCastGroupMsg extends DKSMessage {
  public final static String NAME = "CREATEMCASTGROUPMSG";
  private long groupId;
  DKSRef source;
  DKSRef groupNode;

  public String getName() {
    return NAME;
  }

  public long getGroupId() {
    return groupId;
  }

  public DKSRef getSource() {
    return source;
  }

  public DKSRef getGroupNode() {
    return groupNode;
  }

  public CreateMCastGroupMsg() {
  }

  public CreateMCastGroupMsg(long id, DKSRef source, DKSRef groupNode) {
    groupId = id;
    this.source = source;
    this.groupNode = groupNode;
  }

  public void marshal() throws IOException {
    marshaler.addLong(groupId, "groupid");
    marshaler.addDKSRef(source, "source");
    marshaler.addDKSRef(groupNode, "groupnode");

  }

  public void unmarshal() throws IOException {
    groupId   = marshaler.remLong("groupid");
    source    = marshaler.remDKSRef("source");
    groupNode = marshaler.remDKSRef("groupnode");
  }
}
