package org.kth.dks.dks_dht;

import java.io.IOException;

import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class ChangeItemMsg extends DKSMessage {
  public final static String NAME = "CHANGEITEMMSG";
  public DKSObject oldPayload = null;
  public DKSObject newPayload = null;
  public long key;
  public int index;

  public String getName() {
    return NAME;
  }

  public ChangeItemMsg() {
  }

  public ChangeItemMsg(long id, int i, DKSObject oldpld, DKSObject newpld) {
    key = id;
    oldPayload = oldpld;
    newPayload = newpld;
    index = i ;
  }

  public DKSObject getOldPayLoad() { return oldPayload; }

  public DKSObject getNewPayLoad() { return newPayload; }

  public long getMsgId() { return key; }

  public void marshal() throws IOException {
    marshaler.addLong(key, "key");
    marshaler.addDKSObject(oldPayload, "oldpayload");
    marshaler.addDKSObject(newPayload, "newpayload");
    marshaler.addInt(index, "index");

  }

  public void unmarshal() throws IOException {
    key        = marshaler.remLong("key");
    oldPayload = marshaler.remDKSObject("oldpayload");
    newPayload = marshaler.remDKSObject("newpayload");
    index      = marshaler.remInt("index");
  }
}
