package org.kth.dks.dks_comm;

import java.util.Hashtable;

  class ConnMessageTypes{

    private String name;
    private byte number;
    static private Hashtable typeTable=new Hashtable();

    static final public ConnMessageTypes ACK_MSG      = new ConnMessageTypes("ACK_MSG", (byte)1);
    static final public ConnMessageTypes CONTENTS_MSG = new ConnMessageTypes("CONTENTS_MSG", (byte)2);
    static final public ConnMessageTypes PRESENT_MSG  = new ConnMessageTypes("PRESENT_MSG", (byte)3);

      private ConnMessageTypes(String name, byte number) {
        this.name=name;
        this.number=number;
        typeTable.put(new Byte(number),this);
      }

      public String toString() {
        return name;
      }

      public byte toByte() {
        return number;
      }

      static public ConnMessageTypes valueOf(byte type) {
        return (ConnMessageTypes)typeTable.get(new Byte(type));
      }
  }
