package org.kth.dks;

/**
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: KTH-IMIT/SICS</p>
 * @author Ali Ghodsi (aligh@kth.se)
 * @version 1.0
 */

import java.util.HashMap;
import java.util.Map;

public class DKSObjectTypes {
  private static Map ht = new HashMap(); // must be the first static

  private final String NAME;

  public static final DKSObjectTypes DEFAULT = new DKSObjectTypes("DF");
  public static final DKSObjectTypes DKSRESTBCAST = new DKSObjectTypes("RESTBCAST");
  public static final DKSObjectTypes DKSMSG = new DKSObjectTypes("DKSMSG");
  public static final DKSObjectTypes APP = new DKSObjectTypes("APP");

  private DKSObjectTypes(String N) {
    NAME = N;
    if (ht==null) ht = new HashMap(); // to ensure that the static ht is created before the other statics
    ht.put(NAME, this);
  }

  public String getName() {
    return NAME;
  }

  public String toString() {
    return NAME;
  }

  public static DKSObjectTypes valueOf(String n) {
    return (DKSObjectTypes) ht.get(n);
  }
}
