package org.kth.dks;

import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

/**
 * The DKSMessagingInterface presents a basic messaging interface by
 * which a message can be sent directly to a node, to which a
 * reference is held. Note that no DKS routing occurs.
 */

public interface DKSMessagingInterface  {

  /**
   * Send a message directly to a node.
   *
   * @param dest The destination address.
   * @param msg The message to be sent.
   */
    public boolean send(DKSRef dest, DKSMessage msg);
}

