package org.kth.dks;

/**
 *
 * An important concept used by this interface is that the value
 * bound to a key using the DKS DHT should be treated as an array
 * of DKSObject, and that it shall be possible to modify this array
 * atomically.
 *
 * The DKSObject structure consists of arbitrary contents represented
 * by a java.lang.Object, along with an integer content identifier.
 * Two DKSObject are considered equal if they have equal content
 * identifiers.
 *
 * Keys are represented by long (64 bit) integers in this interface.
 * It is up to other services using this interface to translate application
 * specific keys to this representation.
 */

public interface DKSDHTInterface extends DKSInterface {


    /**
     * Value is added to the list of bindings associated with key.
     *
     */
    public void addToBinding(long key, DKSObject value);

    /**
     * Value is removed from the list of bindings associated with key.
     *
     * Any ocurrence of value in the list is determined by comparison
     * of the DKSObject content identifier.
     */
    public void removeFromBinding(long key, DKSObject value);
    /**
     * All ocurrences of oldValue in the bindings associated with key
     * are replaced by newValue.
     *
     * Any ocurrence of value in the list is determined by comparison
     * of the DKSObject content identifier.
     */
    public void changeBinding(long key, DKSObject oldValue, DKSObject newValue);
    /**
     * Returns the list of bindings associated with key.
     *
     * Any ocurrence of value in the list is determined by comparison
     * of the DKSObject content identifier.
     */

    /**
     * Returns a vector of DKSObjects associated with <code>key</code>
     * in the DHT
     * @param key long specifying the key to be looked up
     * @return <code>DKSObject[]</code> with values associated to
     * <code>key</code>
     * @return <code>null</code> if no values are associated with
     * <code>key</code>
     */
    public DKSObject[] lookupBinding(long key);

    /**
     * Returns a list of all bindings associated with keys
     * greater than or equal to minKey,
     * and less than or equal to maxKey.
     */
    public DKSObject[] lookupBinding(long minKey, long maxKey);

    /**
     * Send the message to the specified recipient node.
     */

    /**
     * Broadcast a message to all nodes
     */
    public void	broadcast(DKSObject message);

    
}
