package org.kth.dks;

/**
 * Defines an interface for callbacks that DKSNode implements, which should be called by every application
 * implementing DKSAppInterface!
 * <p>Title: DKS</p>
 * <p>Description: DKS Middleware</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: KTH-IMIT/SICS</p>
 * @author not attributable
 * @version 1.0
 */
public interface DKSCallbackInterface {
  /**
   * <b>INVARIANT:</b> should be called by DKSAppInterface every time DKSAppInterface.joinCallback() is called
   * @see DKSAppInterface
   */
  public void joinCallbackReturn();

  /**
   * <b>INVARIANT:</b> should be called by DKSAppInterface every time DKSAppInterface.leaveCallback() is called
   * @see DKSAppInterface
   */
  public void leaveCallbackReturn();

  /**
   *
   * Instructs the DKS system to pass on all received messages to the
   * specified DKSAppInterface which contains the proper callbacks.
   * Please look at DKSAppInterface for more information
   *
   * @param receiver DKSAppInterface interface to the application for callbacks
   * @return DKSCallbackInterface an interface for DKS callbacks, which the application will invoke
   * @see DKSCallBackInterface, DKSAppInterface
   */
  public DKSCallbackInterface setCallbackHandler(DKSAppInterface receiver);
}
