/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.splitstream;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Vector;
import rice.environment.Environment;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.transport.TransportPastryNodeFactory;
import rice.tutorial.splitstream.MySplitStreamClient;

public class SplitStreamTutorial {
    Vector<MySplitStreamClient> apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitStreamTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env, boolean useDirect) throws Exception {
        TransportPastryNodeFactory factory;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        if (useDirect) {
            EuclideanNetwork<DirectNodeHandle, RawMessage> sim = new EuclideanNetwork<DirectNodeHandle, RawMessage>(env);
            factory = new DirectPastryNodeFactory(nidFactory, sim, env);
        } else {
            factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        }
        PastryIdFactory idFactory = new PastryIdFactory(env);
        Serializable bootHandle = null;
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = factory.newNode();
            MySplitStreamClient app = new MySplitStreamClient(node);
            this.apps.add(app);
            node.boot(bootHandle);
            if (bootHandle == null) {
                bootHandle = useDirect ? node.getLocalHandle() : bootaddress;
            }
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
        }
        Iterator<MySplitStreamClient> i = this.apps.iterator();
        MySplitStreamClient app = i.next();
        app.subscribe();
        app.startPublishTask();
        while (i.hasNext()) {
            app = i.next();
            app.subscribe();
        }
        env.getTimeSource().sleep(5000L);
    }

    public static void main(String[] args) throws Exception {
        try {
            int numNodes;
            Environment env;
            boolean useDirect = args[0].equalsIgnoreCase("-direct");
            if (useDirect) {
                env = Environment.directEnvironment();
            } else {
                env = new Environment();
                env.getParameters().setString("nat_search_policy", "never");
            }
            int bindport = 0;
            InetSocketAddress bootaddress = null;
            if (!useDirect) {
                bindport = Integer.parseInt(args[0]);
                InetAddress bootaddr = InetAddress.getByName(args[1]);
                int bootport = Integer.parseInt(args[2]);
                numNodes = Integer.parseInt(args[3]);
                bootaddress = new InetSocketAddress(bootaddr, bootport);
            } else {
                numNodes = Integer.parseInt(args[1]);
            }
            SplitStreamTutorial dt = new SplitStreamTutorial(bindport, bootaddress, numNodes, env, useDirect);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson6.ScribeTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

