/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.remotesocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;

public class MyApp
implements Application {
    protected Endpoint endpoint;
    protected Node node;
    ByteBuffer in;
    int MSG_LENGTH;

    public MyApp(Node node, final IdFactory factory) {
        this.endpoint = node.buildEndpoint(this, "myinstance");
        this.node = node;
        this.MSG_LENGTH = node.getLocalNodeHandle().getId().toByteArray().length;
        this.in = ByteBuffer.allocate(this.MSG_LENGTH);
        this.endpoint.accept(new AppSocketReceiver(){

            public void receiveSocket(AppSocket socket) {
                socket.register(true, false, 30000, this);
                MyApp.this.endpoint.accept(this);
            }

            public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                MyApp.this.in.clear();
                try {
                    long ret = socket.read(MyApp.this.in);
                    if (ret != (long)MyApp.this.MSG_LENGTH) {
                        System.out.println("Error, we only received part of a message." + ret + " from " + socket);
                        return;
                    }
                    System.out.println(MyApp.this.node.getLocalNodeHandle() + " Received message from " + factory.buildId(MyApp.this.in.array()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }

            public void receiveException(AppSocket socket, Exception e) {
                e.printStackTrace();
            }
        });
        this.endpoint.register();
    }

    public Node getNode() {
        return this.node;
    }

    public void deliver(Id id, Message message) {
        System.out.println(this + " received " + message);
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public String toString() {
        return "MyApp " + this.endpoint.getId();
    }
}

