/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.io.Serializable;
import java.util.SortedMap;
import rice.Continuation;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.persistence.Cache;
import rice.persistence.Storage;
import rice.persistence.StorageManager;

public class StorageManagerImpl
implements StorageManager {
    private IdFactory factory;
    private Storage storage;
    private Cache cache;

    public StorageManagerImpl(IdFactory factory, Storage storage, Cache cache) {
        this.factory = factory;
        this.storage = storage;
        this.cache = cache;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean exists(Id id) {
        return this.storage.exists(id);
    }

    public void rename(final Id oldId, final Id newId, Continuation c) {
        this.cache.rename(oldId, newId, new Continuation.StandardContinuation(c){

            public void receiveResult(Object o) {
                StorageManagerImpl.this.storage.rename(oldId, newId, this.parent);
            }

            public String toString() {
                return "rename of " + oldId + " to " + newId;
            }
        });
    }

    public void getObject(final Id id, Continuation c) {
        this.cache.getObject(id, new Continuation.StandardContinuation(c){

            public void receiveResult(Object o) {
                if (o != null) {
                    this.parent.receiveResult(o);
                } else {
                    StorageManagerImpl.this.storage.getObject(id, this.parent);
                }
            }

            public String toString() {
                return "getObject of " + id;
            }
        });
    }

    public Serializable getMetadata(Id id) {
        return this.storage.getMetadata(id);
    }

    public void setMetadata(final Id id, final Serializable metadata, Continuation command) {
        this.cache.setMetadata(id, metadata, new Continuation.StandardContinuation(command){

            public void receiveResult(Object o) {
                StorageManagerImpl.this.storage.setMetadata(id, metadata, this.parent);
            }

            public String toString() {
                return "setMetadata of " + id;
            }
        });
    }

    public IdSet scan(IdRange range) {
        return this.storage.scan(range);
    }

    public IdSet scan() {
        return this.storage.scan();
    }

    public SortedMap scanMetadata(IdRange range) {
        return this.storage.scanMetadata(range);
    }

    public SortedMap scanMetadata() {
        return this.storage.scanMetadata();
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        return this.storage.scanMetadataValuesHead(value);
    }

    public SortedMap scanMetadataValuesNull() {
        return this.storage.scanMetadataValuesNull();
    }

    public long getTotalSize() {
        return this.cache.getTotalSize() + this.storage.getTotalSize();
    }

    public int getSize() {
        return this.storage.getSize();
    }

    public void store(Id id, Serializable metadata, Serializable obj, Continuation c) {
        this.storage.store(id, metadata, obj, c);
    }

    public void unstore(Id id, Continuation c) {
        this.storage.unstore(id, c);
    }

    public void cache(Id id, Serializable metadata, Serializable obj, Continuation c) {
        this.cache.cache(id, metadata, obj, c);
    }

    public void uncache(Id id, Continuation c) {
        this.cache.uncache(id, c);
    }

    public long getMaximumSize() {
        return this.cache.getMaximumSize();
    }

    public void setMaximumSize(int size, Continuation c) {
        this.cache.setMaximumSize(size, c);
    }

    public void flush(Continuation c) {
        this.cache.flush(new Continuation.StandardContinuation(c){

            public void receiveResult(Object o) {
                StorageManagerImpl.this.storage.flush(this.parent);
            }
        });
    }
}

