/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAdapter<Identifier>
implements AppSocket,
P2PSocketReceiver<Identifier> {
    P2PSocket<Identifier> internal;
    Logger logger;
    Environment environment;
    AppSocketReceiver reader = null;
    AppSocketReceiver writer = null;

    public SocketAdapter(P2PSocket<Identifier> socket, Environment env) {
        this.internal = socket;
        this.logger = env.getLogManager().getLogger(SocketAdapter.class, null);
        this.environment = env;
    }

    @Override
    public void close() {
        this.internal.close();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = 0L;
        for (int i = offset; i < offset + length; ++i) {
            ret += this.internal.read(dsts[i]);
        }
        return ret;
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, int timeout, AppSocketReceiver receiver) {
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading. Can't register " + receiver);
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            if (this.writer != null && this.writer != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for writing. Can't register " + receiver);
            }
            this.writer = receiver;
        }
        this.internal.register(wantToRead, wantToWrite, this);
    }

    @Override
    public void receiveException(P2PSocket<Identifier> s, Exception e) {
        AppSocketReceiver temp;
        if (this.writer != null) {
            if (this.writer == this.reader) {
                temp = this.writer;
                this.writer = null;
                this.reader = null;
                temp.receiveException(this, e);
            } else {
                temp = this.writer;
                this.writer = null;
                temp.receiveException(this, e);
            }
        }
        if (this.reader != null) {
            temp = this.reader;
            this.reader = null;
            temp.receiveException(this, e);
        }
    }

    @Override
    public void receiveSelectResult(P2PSocket<Identifier> s, boolean canRead, boolean canWrite) throws IOException {
        AppSocketReceiver temp;
        if (this.logger.level <= 300) {
            this.logger.log(this + "rsr(" + this.internal + "," + canRead + "," + canWrite + ")");
        }
        if (canRead && canWrite && this.reader == this.writer) {
            AppSocketReceiver temp2 = this.reader;
            this.reader = null;
            this.writer = null;
            temp2.receiveSelectResult(this, canRead, canWrite);
            return;
        }
        if (canRead) {
            temp = this.reader;
            if (temp == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("no reader in " + this + ".rsr(" + this.internal + "," + canRead + "," + canWrite + ")");
                }
            } else {
                this.reader = null;
                temp.receiveSelectResult(this, true, false);
            }
        }
        if (canWrite) {
            temp = this.writer;
            if (temp == null) {
                if (this.logger.level <= 900) {
                    this.logger.log("no writer in " + this + ".rsr(" + this.internal + "," + canRead + "," + canWrite + ")");
                }
            } else {
                this.writer = null;
                temp.receiveSelectResult(this, false, true);
            }
        }
    }

    @Override
    public void shutdownOutput() {
        this.internal.shutdownOutput();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = 0L;
        for (int i = offset; i < offset + length; ++i) {
            ret += this.internal.write(srcs[i]);
        }
        return ret;
    }

    @Override
    public long read(ByteBuffer dst) throws IOException {
        return this.internal.read(dst);
    }

    @Override
    public long write(ByteBuffer src) throws IOException {
        return this.internal.write(src);
    }

    public String toString() {
        return "SA[" + this.internal + "]";
    }
}

