/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.testing.PingAddress;
import rice.pastry.testing.PingMessageNew;
import rice.pastry.testing.PingTestRecord;

public class Ping
extends PastryAppl {
    private static int pingAddress = PingAddress.getCode();

    public Ping(PastryNode pn) {
        super(pn);
    }

    public int getAddress() {
        return pingAddress;
    }

    public void sendPing(Id nid) {
        this.routeMsg(nid, new PingMessageNew(pingAddress, this.getNodeHandle(), nid), new SendOptions());
    }

    public void messageForAppl(Message msg) {
        PingMessageNew pMsg = (PingMessageNew)msg;
        int nHops = pMsg.getHops() - 1;
        double fDistance = pMsg.getDistance();
        NetworkSimulator sim = ((DirectNodeHandle)this.thePastryNode.getLocalHandle()).getSimulator();
        PingTestRecord tr = (PingTestRecord)sim.getTestRecord();
        double dDistance = sim.networkDelay((DirectNodeHandle)this.thePastryNode.getLocalHandle(), (DirectNodeHandle)pMsg.getSender());
        double rDistance = dDistance == 0.0 ? 0.0 : fDistance / dDistance;
        tr.addHops(nHops);
        tr.addDistance(rDistance);
    }

    public boolean enrouteMessage(Message msg, Id from, NodeHandle nextHop, SendOptions opt) {
        PingMessageNew pMsg = (PingMessageNew)msg;
        pMsg.incrHops();
        pMsg.incrDistance(((DirectNodeHandle)this.thePastryNode.getLocalHandle()).getSimulator().networkDelay((DirectNodeHandle)this.thePastryNode.getLocalHandle(), (DirectNodeHandle)nextHop));
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }
}

