/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;

public class PartitionChecker {
    protected final int MAX_THREADS = 100;
    int numThreads = 0;
    HashSet<InetSocketAddress> unmatchedBootstraps;
    HashSet<InetSocketAddress> bootstraps;
    final PrintStream ps = new PrintStream(new FileOutputStream("response.txt"));
    ArrayList<Ring> rings;
    Environment environment;
    HashSet<NodeHandle> dead = new HashSet();

    public PartitionChecker(String ringIdString) throws Exception {
        this.environment = new Environment();
        this.buildBootstrapSetFromCert(ringIdString);
        this.rings = new ArrayList();
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(null, 1, this.environment);
        while (this.unmatchedBootstraps.size() > 0) {
            this.rings.add(this.buildRing(factory, this.unmatchedBootstraps.iterator().next()));
        }
        Collections.sort(this.rings);
        Iterator<Ring> i = this.rings.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    protected void buildBootstrapSetFromCert(String ringIdString) throws Exception {
        this.unmatchedBootstraps = new HashSet();
        this.bootstraps = new HashSet();
        BufferedReader in = new BufferedReader(new FileReader(ringIdString));
        while (in.ready()) {
            String line = in.readLine();
            String[] parts = line.split(":");
            int port = 10003;
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
            }
            InetSocketAddress addr = new InetSocketAddress(parts[0], port);
            this.unmatchedBootstraps.add(addr);
            this.bootstraps.add(addr);
        }
    }

    protected LeafSet getLeafSet(NodeHandle nh) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ring buildRing(SocketPastryNodeFactory factory, InetSocketAddress bootstrap) throws Exception {
        this.unmatchedBootstraps.remove(bootstrap);
        this.numThreads = 0;
        final Ring ring = new Ring(bootstrap);
        final HashSet<NodeHandle> unseen = new HashSet<NodeHandle>();
        unseen.add(factory.getNodeHandle(bootstrap, 20000));
        HashSet<NodeHandle> hashSet = unseen;
        synchronized (hashSet) {
            while (true) {
                if (this.numThreads >= 100) {
                    unseen.wait();
                }
                if (unseen.size() > 0) {
                    ++this.numThreads;
                    final SocketNodeHandle handle = (SocketNodeHandle)unseen.iterator().next();
                    if (handle == null) break;
                    unseen.remove(handle);
                    ring.addNode(handle);
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                Iterable<NodeHandle> ls = PartitionChecker.this.getLeafSet(handle);
                                PartitionChecker.this.ps.println(handle.getInetSocketAddress().getAddress().getHostAddress() + ":" + handle.getInetSocketAddress().getPort());
                                NodeSet ns = ls.neighborSet(Integer.MAX_VALUE);
                                if (!ns.get(0).equals(handle)) {
                                    ring.addFailure(handle, new Exception("Node is now " + ns.get(0)));
                                }
                                HashSet hashSet = unseen;
                                synchronized (hashSet) {
                                    for (int i = 1; i < ns.size(); ++i) {
                                        if (ring.contains(ns.get(i)) || PartitionChecker.this.dead.contains(ns.get(i))) continue;
                                        unseen.add(ns.get(i));
                                    }
                                }
                            }
                            catch (ConnectException e) {
                                ring.addFailure(handle, e);
                                PartitionChecker.this.dead.add(handle);
                            }
                            catch (SocketTimeoutException e) {
                                ring.addFailure(handle, e);
                                PartitionChecker.this.dead.add(handle);
                            }
                            catch (IOException iOException) {
                                HashSet hashSet = unseen;
                                synchronized (hashSet) {
                                    --PartitionChecker.this.numThreads;
                                    unseen.notifyAll();
                                }
                            }
                            finally {
                                HashSet e = unseen;
                                synchronized (e) {
                                    --PartitionChecker.this.numThreads;
                                    unseen.notifyAll();
                                }
                            }
                        }
                    };
                    t.start();
                    continue;
                }
                if (this.numThreads <= 0) break;
                unseen.wait();
            }
        }
        System.out.println("buildRing() complete:" + ring);
        return ring;
    }

    public static void main(String[] args) throws Exception {
        new PartitionChecker(args[0]);
        System.exit(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Ring
    implements Comparable<Ring> {
        HashSet<InetSocketAddress> myBootstraps;
        HashSet<NodeHandle> nodes;
        String name;

        public Ring(InetSocketAddress bootAddr) {
            this.name = bootAddr.toString();
            this.myBootstraps = new HashSet();
            this.myBootstraps.add(bootAddr);
            this.nodes = new HashSet();
        }

        public boolean contains(NodeHandle handle) {
            return this.nodes.contains(handle);
        }

        public String getName() {
            return this.name;
        }

        public void addFailure(SocketNodeHandle handle, Exception e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addNode(SocketNodeHandle snh) {
            InetSocketAddress newAddr = snh.getInetSocketAddress();
            HashSet<InetSocketAddress> hashSet = PartitionChecker.this.unmatchedBootstraps;
            synchronized (hashSet) {
                if (PartitionChecker.this.unmatchedBootstraps.contains(newAddr)) {
                    PartitionChecker.this.unmatchedBootstraps.remove(newAddr);
                }
            }
            if (PartitionChecker.this.bootstraps.contains(newAddr)) {
                this.myBootstraps.add(newAddr);
            }
            this.nodes.add(snh);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String s = this.nodes.size() + ":" + this.myBootstraps.size() + ": boots:";
            HashSet<Serializable> hashSet = this.myBootstraps;
            synchronized (hashSet) {
                Iterator<Serializable> i = this.myBootstraps.iterator();
                s = s + i.next();
                while (i.hasNext()) {
                    s = s + "," + i.next();
                }
            }
            s = s + " non-boots:";
            hashSet = this.nodes;
            synchronized (hashSet) {
                for (NodeHandle nxt : this.nodes) {
                    if (PartitionChecker.this.bootstraps.contains(nxt)) continue;
                    s = s + "," + nxt;
                }
            }
            return s;
        }

        @Override
        public int compareTo(Ring arg0) {
            Ring that = arg0;
            return this.size() - that.size();
        }

        public int size() {
            return this.nodes.size();
        }
    }
}

