/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.environment.random.RandomSource;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.testing.HelloMsg;

public class HelloWorldApp
extends PastryAppl {
    private int msgid = 0;
    private static int addr = HelloAddress.getCode();

    public HelloWorldApp(PastryNode pn) {
        super(pn, null, addr, null);
        this.register();
    }

    public void sendRndMsg(RandomSource rng) {
        Id rndid = Id.makeRandomId(rng);
        if (this.logger.level <= 500) {
            System.out.println("Sending message from " + this.getNodeId() + " to random dest " + rndid);
        }
        HelloMsg msg = new HelloMsg(addr, this.thePastryNode.getLocalHandle(), rndid, ++this.msgid);
        this.routeMsg(rndid, msg, new SendOptions());
    }

    public int getAddress() {
        return addr;
    }

    public void messageForAppl(Message msg) {
        if (this.logger.level <= 500) {
            System.out.println("Received " + msg + " at " + this.getNodeId());
        }
    }

    public boolean enrouteMessage(Message msg, Id key, NodeHandle nextHop, SendOptions opt) {
        if (this.logger.level <= 400) {
            System.out.println("Enroute " + msg + " at " + this.getNodeId());
        }
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        if (this.logger.level <= 300) {
            String s = "In " + this.getNodeId() + "'s leaf set, " + "node " + nh.getNodeId() + " was ";
            s = wasAdded ? s + "added" : s + "removed";
            System.out.println(s);
        }
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
        if (this.logger.level <= 300) {
            String s = "In " + this.getNodeId() + "'s route set, " + "node " + nh.getNodeId() + " was ";
            s = wasAdded ? s + "added" : s + "removed";
            System.out.println(s);
        }
    }

    public void notifyReady() {
        if (this.logger.level <= 800) {
            System.out.println("Node " + this.getNodeId() + " ready, waking up any clients");
        }
    }

    private static class HelloAddress {
        private static int myCode = 428125133;

        private HelloAddress() {
        }

        public static int getCode() {
            return myCode;
        }
    }
}

