/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.pastry.IdSet;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocol;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;

public class StandardLeafSetProtocol
extends PastryAppl
implements LeafSetProtocol,
Observer {
    protected final boolean failstop = true;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    protected Logger logger;
    HashSet<NodeHandle> cachedSet = null;

    public StandardLeafSetProtocol(PastryNode ln, NodeHandle local, LeafSet ls, RoutingTable rt) {
        super(ln, LeafSetProtocolAddress.getCode());
        this.leafSet = ls;
        for (NodeHandle nh : this.leafSet.asList()) {
            nh.addObserver(this);
        }
        this.cachedSet = new HashSet(this.leafSet.maxSize() * 2);
        this.routeTable = rt;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    public void messageForAppl(Message msg) {
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            int type = bls.type();
            NodeHandle from = bls.from();
            LeafSet remotels = bls.leafSet();
            boolean changed = this.mergeLeafSet(remotels, from);
            if (type == 1) {
                // empty if block
            }
            if (type == 1) {
                this.broadcast();
            }
            if (type == 3 && changed) {
                this.broadcast();
            }
            this.checkLeafSet(remotels, from, true);
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            NodeHandle returnHandle = rls.returnHandle();
            if (returnHandle.isAlive()) {
                BroadcastLeafSet bls = new BroadcastLeafSet(this.thePastryNode.getLocalHandle(), this.leafSet, 0, rls.getTimeStamp());
                this.thePastryNode.send(returnHandle, bls, null, this.options);
            }
        } else if (msg instanceof InitiateLeafSetMaintenance) {
            this.maintainLeafSet();
        } else {
            throw new Error("message received is of unknown type");
        }
    }

    protected boolean checkLeafSet(LeafSet remotels, NodeHandle from, boolean notifyMissing) {
        HashSet<NodeHandle> insertedHandles;
        if (notifyMissing) {
            this.cachedSet.clear();
            insertedHandles = this.cachedSet;
        } else {
            insertedHandles = null;
        }
        BroadcastLeafSet bl = new BroadcastLeafSet(this.thePastryNode.getLocalHandle(), this.leafSet, 3, 0L);
        boolean changed = remotels.merge(this.leafSet, this.thePastryNode.getLocalHandle(), null, true, insertedHandles);
        if (changed) {
            this.thePastryNode.send(from, bl, null, this.options);
            if (notifyMissing) {
                for (NodeHandle nh : new ArrayList<NodeHandle>(insertedHandles)) {
                    this.thePastryNode.send(nh, bl, null, this.options);
                }
            }
        }
        return changed;
    }

    protected boolean mergeLeafSet(LeafSet remotels, NodeHandle from) {
        return this.leafSet.merge(remotels, from, this.routeTable, false, null);
    }

    protected void broadcast() {
        this.broadcast(2);
    }

    protected void broadcast(int type) {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.thePastryNode.getLocalHandle(), this.leafSet, type, 0L);
        int cwSize = this.leafSet.cwSize();
        int ccwSize = this.leafSet.ccwSize();
        IdSet sent = new IdSet();
        for (int i = -ccwSize; i <= cwSize; ++i) {
            NodeHandle nh;
            if (i == 0 || (nh = this.leafSet.get(i)) == null || !nh.isAlive() || sent.isMember(nh.getNodeId())) continue;
            this.thePastryNode.send(nh, bls, null, this.options);
            sent.addMember(nh.getNodeId());
        }
    }

    protected void broadcast(LeafSet ls, NodeHandle from) {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.thePastryNode.getLocalHandle(), this.leafSet, 2, 0L);
        int cwSize = ls.cwSize();
        int ccwSize = ls.ccwSize();
        for (int i = -ccwSize; i <= cwSize; ++i) {
            NodeHandle nh = i == 0 ? from : ls.get(i);
            if (nh == null || !nh.isAlive()) continue;
            this.thePastryNode.send(nh, bls, null, this.options);
        }
    }

    public void maintainLeafSet() {
        NodeHandle nh;
        int i;
        if (this.logger.level <= 500) {
            this.logger.log("maintainLeafSet " + this.thePastryNode.getLocalHandle().getNodeId());
        }
        boolean lostMembers = false;
        for (i = -this.leafSet.ccwSize(); i < 0; ++i) {
            nh = this.leafSet.get(i);
            if (nh == null || nh.ping()) continue;
            this.leafSet.remove(nh);
            lostMembers = true;
        }
        for (i = this.leafSet.cwSize(); i > 0; --i) {
            nh = this.leafSet.get(i);
            if (nh == null || nh.ping()) continue;
            this.leafSet.remove(nh);
            lostMembers = true;
        }
        if (lostMembers || this.leafSet.size() < this.leafSet.maxSize()) {
            this.requestLeafSet();
        }
    }

    private void requestLeafSet() {
        NodeHandle handle;
        int i;
        RequestLeafSet rls = new RequestLeafSet(this.thePastryNode.getLocalHandle(), this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis());
        int cwSize = this.leafSet.cwSize();
        int ccwSize = this.leafSet.ccwSize();
        boolean allDead = true;
        for (i = -ccwSize; i < 0; ++i) {
            handle = this.leafSet.get(i);
            if (handle == null || !handle.isAlive()) continue;
            this.thePastryNode.send(handle, rls, null, this.options);
            allDead = false;
            break;
        }
        if (allDead && this.leafSet.size() > 0 && this.logger.level <= 1000) {
            this.logger.log("Ring failure at" + this.thePastryNode.getLocalHandle().getNodeId() + "all ccw leafset entries failed");
        }
        allDead = true;
        for (i = cwSize; i > 0; --i) {
            handle = this.leafSet.get(i);
            if (handle == null || !handle.isAlive()) continue;
            this.thePastryNode.send(handle, rls, null, this.options);
            allDead = false;
            break;
        }
        if (allDead && this.leafSet.size() > 0 && this.logger.level <= 1000) {
            this.logger.log("Ring failure at" + this.thePastryNode.getLocalHandle().getNodeId() + "all cw leafset entries failed");
        }
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        super.leafSetChange(nh, wasAdded);
        if (wasAdded) {
            nh.addObserver(this);
        } else {
            nh.deleteObserver(this);
        }
    }

    public void update(Observable o, Object arg) {
        if (arg == NodeHandle.DECLARED_DEAD) {
            this.leafSet.remove((NodeHandle)o);
        }
    }
}

