/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.Id;
import rice.pastry.NodeIdFactory;

public class RandomNodeIdFactory
implements NodeIdFactory {
    private long next;
    Environment environment;
    protected Logger logger;

    public RandomNodeIdFactory(Environment env) {
        this.environment = env;
        this.next = env.getRandomSource().nextLong();
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
    }

    public Id generateNodeId() {
        byte[] raw = new byte[8];
        long tmp = ++this.next;
        for (int i = 0; i < 8; ++i) {
            raw[i] = (byte)(tmp & 0xFFL);
            tmp >>= 8;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("No SHA support!");
            }
            throw new RuntimeException("No SHA support!", e);
        }
        md.update(raw);
        byte[] digest = md.digest();
        Id nodeId = Id.build(digest);
        return nodeId;
    }
}

