/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import java.util.Map;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.rendezvous.ContactDirectStrategy;
import org.mpisws.p2p.transport.rendezvous.PilotManager;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.Continuation;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.join.JoinRequest;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.nat.rendezvous.RendezvousJoinRequest;
import rice.pastry.socket.nat.rendezvous.RendezvousSocketNodeHandle;
import rice.pastry.standard.ConsistentJoinProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendezvousJoinProtocol
extends ConsistentJoinProtocol {
    PilotManager<RendezvousSocketNodeHandle> pilotManager;

    public RendezvousJoinProtocol(PastryNode ln, NodeHandle lh, RoutingTable rt, LeafSet ls, ReadyStrategy nextReadyStrategy, PilotManager<RendezvousSocketNodeHandle> pilotManager) {
        super(ln, lh, rt, ls, nextReadyStrategy, new RCJPDeserializer(ln));
        this.pilotManager = pilotManager;
    }

    @Override
    protected void getJoinRequest(NodeHandle b, final Continuation<JoinRequest, Exception> deliverJRToMe) {
        final RendezvousSocketNodeHandle bootstrap = (RendezvousSocketNodeHandle)b;
        ContactDirectStrategy contactStrat = (ContactDirectStrategy)this.thePastryNode.getVars().get("RendezvousSocketPastryNodeFactory.ContactDirectStrategy");
        if (((RendezvousSocketNodeHandle)this.thePastryNode.getLocalHandle()).canContactDirect() || !bootstrap.canContactDirect() && contactStrat.canContactDirect(bootstrap)) {
            super.getJoinRequest(bootstrap, deliverJRToMe);
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("opening pilot to " + bootstrap);
        }
        this.pilotManager.openPilot(bootstrap, new Continuation<SocketRequestHandle<RendezvousSocketNodeHandle>, Exception>(){

            @Override
            public void receiveException(Exception exception) {
                deliverJRToMe.receiveException(exception);
            }

            @Override
            public void receiveResult(SocketRequestHandle<RendezvousSocketNodeHandle> result) {
                RendezvousJoinRequest jr = new RendezvousJoinRequest(RendezvousJoinProtocol.this.localHandle, RendezvousJoinProtocol.this.thePastryNode.getRoutingTable().baseBitLength(), RendezvousJoinProtocol.this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis(), bootstrap);
                deliverJRToMe.receiveResult(jr);
            }
        });
    }

    @Override
    protected Map<String, Object> getOptions(JoinRequest jr, Map<String, Object> existing) {
        if (jr.accepted() && jr instanceof RendezvousJoinRequest) {
            RendezvousJoinRequest rjr = (RendezvousJoinRequest)jr;
            return OptionsFactory.addOption(existing, "USE_PILOT", rjr.getPilot());
        }
        return existing;
    }

    static class RCJPDeserializer
    extends ConsistentJoinProtocol.CJPDeserializer {
        public RCJPDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 4: {
                    return new RendezvousJoinRequest(buf, this.pn, sender, this.pn);
                }
            }
            return super.deserialize(buf, type, priority, sender);
        }
    }
}

