/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.rendezvous;

import java.io.IOException;
import java.nio.ByteBuffer;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.messaging.PRawMessage;

public class ByteBufferMsg
extends PRawMessage {
    public static final short TYPE = 1;
    NodeHandle originalSender;
    ByteBuffer buffer;

    public ByteBufferMsg(ByteBuffer buf, NodeHandle sender, int priority, int dest) {
        super(dest);
        this.buffer = buf;
        this.setPriority(priority);
        if (sender == null) {
            throw new IllegalArgumentException("Sender == null");
        }
        this.originalSender = sender;
    }

    public String toString() {
        return "BBM[" + this.buffer + "] from " + this.originalSender;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.originalSender.serialize(buf);
        buf.writeInt(this.buffer.remaining());
        buf.write(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
    }

    public NodeHandle getOriginalSender() {
        return this.originalSender;
    }
}

