/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket.nat.probe;

import java.io.IOException;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.messaging.PRawMessage;

public class ProbeRequestMessage
extends PRawMessage {
    public static final short TYPE = 1;
    MultiInetSocketAddress probeRequestor;
    long uid;

    public ProbeRequestMessage(MultiInetSocketAddress probeRequestor, long uid, int appAddress) {
        super(appAddress);
        this.probeRequestor = probeRequestor;
        this.uid = uid;
    }

    public MultiInetSocketAddress getProbeRequester() {
        return this.probeRequestor;
    }

    public long getUID() {
        return this.uid;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)0);
        this.probeRequestor.serialize(buf);
        buf.writeLong(this.uid);
    }

    public static ProbeRequestMessage build(InputBuffer buf, int appAddress) throws IOException {
        byte version = buf.readByte();
        if (version != 0) {
            throw new IllegalStateException("Unknown version: " + version);
        }
        MultiInetSocketAddress addr = MultiInetSocketAddress.build(buf);
        long uid = buf.readLong();
        return new ProbeRequestMessage(addr, uid, appAddress);
    }
}

