/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.util.Map;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.SourceRouteForwardStrategy;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivenesSourceRouteForwardStrategy<Identifier>
implements SourceRouteForwardStrategy<Identifier> {
    Logger logger;
    LivenessProvider<SourceRoute<Identifier>> liveness;
    private SourceRouteFactory<Identifier> factory;

    public LivenesSourceRouteForwardStrategy(SourceRouteFactory<Identifier> factory, Environment env) {
        this.factory = factory;
        this.logger = env.getLogManager().getLogger(LivenesSourceRouteForwardStrategy.class, null);
    }

    public void setLivenessProvider(LivenessProvider<SourceRoute<Identifier>> liveness) {
        this.liveness = liveness;
    }

    @Override
    public boolean forward(Identifier nextHop, SourceRoute<Identifier> sr, boolean socket, Map<String, Object> options) {
        boolean ret;
        if (!socket) {
            return true;
        }
        SourceRoute<Identifier> i = this.factory.getSourceRoute(nextHop);
        boolean bl = ret = this.liveness.getLiveness(i, options) < 3;
        if (!ret && this.logger.level <= 900) {
            this.logger.log("Not forwarding socket to " + nextHop + " sr:" + sr + " because I believe it is dead.");
        }
        return ret;
    }
}

