/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.JavaSerializedDeserializer;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.RouteMessageNotification;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.SendOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteMessage
extends PRawMessage
implements Serializable,
rice.p2p.commonapi.RouteMessage {
    private static final long serialVersionUID = 3492981895989180093L;
    public static final short TYPE = -23525;
    private Id target;
    private NodeHandle destinationHandle;
    private transient byte version;
    private NodeHandle prevNode;
    private transient SendOptions opts;
    private int auxAddress;
    private transient NodeHandle nextHop;
    public Message internalMsg;
    private transient PRawMessage rawInternalMsg = null;
    private transient InputBuffer serializedMsg;
    private transient PastryNode pn;
    boolean hasSender;
    byte internalPriority;
    short internalType;
    public transient int numRetries = 0;
    private RMDeserializer endpointDeserializer = new RMDeserializer();
    private transient Map<String, Object> options;
    Cancellable tlCancellable;
    RouteMessageNotification notifyMe;

    public RouteMessage(Id target, Message msg, byte serializeVersion) {
        this(target, msg, null, null, serializeVersion);
    }

    public RouteMessage(Id target, Message msg, SendOptions opts, byte serializeVersion) {
        this(target, msg, null, opts, serializeVersion);
    }

    public RouteMessage(NodeHandle dest, Message msg, SendOptions opts, byte serializeVersion) {
        this(dest.getNodeId(), msg, dest, opts, serializeVersion);
    }

    public RouteMessage(Id target, Message msg, NodeHandle firstHop, byte serializeVersion) {
        this(target, msg, firstHop, null, serializeVersion);
    }

    private static PRawMessage convert(Message msg) {
        if (msg instanceof PRawMessage) {
            PRawMessage prm = (PRawMessage)msg;
            if (prm.getType() == 0 && prm instanceof PJavaSerializedMessage) {
                throw new RuntimeException("Cannot route a PJavaSerializedMessage, this is used internally in RouteMessage." + msg + " " + msg.getClass().getName());
            }
            return prm;
        }
        return new PJavaSerializedMessage(msg);
    }

    public RouteMessage(Id target, PRawMessage msg, NodeHandle firstHop, SendOptions opts, byte serializeVersion) {
        this(target, (Message)msg, firstHop, opts, serializeVersion);
        this.rawInternalMsg = msg;
        if (msg != null) {
            this.internalType = msg.getType();
        }
    }

    public RouteMessage(Id target, Message msg, NodeHandle firstHop, SendOptions opts, byte serializeVersion) {
        super(RouterAddress.getCode());
        this.version = serializeVersion;
        this.target = target;
        this.internalMsg = msg;
        this.nextHop = firstHop;
        this.opts = opts;
        if (this.opts == null) {
            this.opts = new SendOptions();
        }
        if (msg != null) {
            this.auxAddress = msg.getDestination();
        }
    }

    public Id getTarget() {
        return this.target;
    }

    public NodeHandle getPrevNode() {
        return this.prevNode;
    }

    public void setPrevNode(NodeHandle n) {
        this.prevNode = n;
    }

    public NodeHandle getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(NodeHandle nh) {
        this.nextHop = nh;
    }

    @Override
    public int getPriority() {
        if (this.internalMsg != null) {
            return this.internalMsg.getPriority();
        }
        return this.internalPriority;
    }

    public Message unwrap() {
        if (this.internalMsg != null) {
            return this.internalMsg;
        }
        try {
            this.endpointDeserializer.setSubDeserializer(new JavaSerializedDeserializer(this.pn));
            return this.unwrap(this.endpointDeserializer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public SendOptions getOptions() {
        if (this.opts == null) {
            this.opts = new SendOptions();
        }
        return this.opts;
    }

    public String toString() {
        if (this.internalMsg == null) {
            return "R[serialized{" + this.auxAddress + "," + this.internalType + "}]";
        }
        String str = "R[" + this.internalMsg + "]";
        return str;
    }

    @Override
    public rice.p2p.commonapi.Id getDestinationId() {
        return this.getTarget();
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getNextHopHandle() {
        return this.nextHop;
    }

    @Override
    public rice.p2p.commonapi.Message getMessage() {
        return ((PastryEndpointMessage)this.unwrap()).getMessage();
    }

    @Override
    public rice.p2p.commonapi.Message getMessage(MessageDeserializer md) throws IOException {
        this.endpointDeserializer.setSubDeserializer(md);
        return ((PastryEndpointMessage)this.unwrap(this.endpointDeserializer)).getMessage();
    }

    @Override
    public void setDestinationId(rice.p2p.commonapi.Id id) {
        this.target = (Id)id;
    }

    @Override
    public void setNextHopHandle(rice.p2p.commonapi.NodeHandle nextHop) {
        this.nextHop = (NodeHandle)nextHop;
    }

    @Override
    public void setMessage(rice.p2p.commonapi.Message message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }

    @Override
    public void setMessage(RawMessage message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }

    public static RouteMessage build(InputBuffer buf, byte priority, PastryNode pn, NodeHandle prev, byte outputVersion) throws IOException {
        byte version = buf.readByte();
        switch (version) {
            case 0: {
                int auxAddress = buf.readInt();
                Id target = Id.build(buf);
                return new RouteMessage(target, auxAddress, prev, buf, priority, pn, null, outputVersion);
            }
            case 1: {
                int auxAddress = buf.readInt();
                NodeHandle destHandle = null;
                Id target = null;
                boolean hasDestHandle = buf.readBoolean();
                if (hasDestHandle) {
                    destHandle = pn.readNodeHandle(buf);
                    target = (Id)destHandle.getId();
                } else {
                    target = Id.build(buf);
                }
                return new RouteMessage(target, auxAddress, prev, buf, priority, pn, destHandle, outputVersion);
            }
        }
        throw new IOException("Unknown Version: " + version);
    }

    public RouteMessage(Id target, int auxAddress, NodeHandle prev, InputBuffer buf, byte priority, PastryNode pn, NodeHandle destinationHandle, byte serializeVersion) throws IOException {
        this(target, null, null, null, serializeVersion);
        this.hasSender = buf.readBoolean();
        this.internalPriority = priority;
        this.internalType = buf.readShort();
        this.prevNode = prev;
        this.serializedMsg = buf;
        this.destinationHandle = destinationHandle;
        this.pn = pn;
        this.auxAddress = auxAddress;
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte(this.version);
        buf.writeInt(this.auxAddress);
        switch (this.version) {
            case 0: {
                this.target.serialize(buf);
                break;
            }
            case 1: {
                buf.writeBoolean(this.destinationHandle != null);
                if (this.destinationHandle != null) {
                    this.destinationHandle.serialize(buf);
                    break;
                }
                this.target.serialize(buf);
            }
        }
        if (this.serializedMsg != null) {
            buf.writeBoolean(this.hasSender);
            buf.writeShort(this.internalType);
            byte[] raw = new byte[this.serializedMsg.bytesRemaining()];
            this.serializedMsg.read(raw);
            buf.write(raw, 0, raw.length);
            this.serializedMsg = new SimpleInputBuffer(raw);
        } else {
            NodeHandle sender;
            boolean hasSender;
            if (this.rawInternalMsg == null) {
                this.rawInternalMsg = RouteMessage.convert(this.internalMsg);
            }
            boolean bl = hasSender = (sender = this.rawInternalMsg.getSender()) != null;
            if (hasSender) {
                buf.writeBoolean(true);
            } else {
                buf.writeBoolean(false);
            }
            int priority = this.rawInternalMsg.getPriority();
            if (priority > 127) {
                throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.rawInternalMsg + " was " + priority + ".");
            }
            if (priority < -128) {
                throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + this.rawInternalMsg + " was " + priority + ".");
            }
            short type = this.rawInternalMsg.getType();
            buf.writeShort(type);
            if (hasSender) {
                sender.serialize(buf);
            }
            this.rawInternalMsg.serialize(buf);
        }
    }

    public Message unwrap(MessageDeserializer md) throws IOException {
        if (this.internalMsg != null) {
            return this.internalMsg;
        }
        NodeHandle internalSender = null;
        if (this.hasSender) {
            internalSender = this.pn.readNodeHandle(this.serializedMsg);
        }
        this.internalMsg = (Message)md.deserialize(this.serializedMsg, this.internalType, this.internalPriority, internalSender);
        this.serializedMsg = null;
        this.pn = null;
        return this.internalMsg;
    }

    @Override
    public short getType() {
        return -23525;
    }

    public int getAuxAddress() {
        return this.auxAddress;
    }

    public short getInternalType() {
        if (this.rawInternalMsg != null) {
            return this.rawInternalMsg.getType();
        }
        if (this.internalMsg != null) {
            if (this.internalMsg instanceof RawMessage) {
                return ((RawMessage)((Object)this.internalMsg)).getType();
            }
            return 0;
        }
        return -1;
    }

    public void setDestinationHandle(NodeHandle handle) {
        this.destinationHandle = handle;
    }

    public NodeHandle getDestinationHandle() {
        return this.destinationHandle;
    }

    public Map<String, Object> getTLOptions() {
        return this.options;
    }

    public void setTLOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setTLCancellable(Cancellable c) {
        this.tlCancellable = c;
    }

    public boolean cancel() {
        return this.tlCancellable.cancel();
    }

    public void setRouteMessageNotification(RouteMessageNotification notification) {
        this.notifyMe = notification;
    }

    public void sendSuccess(NodeHandle nextHop) {
        if (this.notifyMe != null) {
            this.notifyMe.sendSuccess(this, nextHop);
        }
    }

    public boolean sendFailed(Exception e) {
        if (this.notifyMe != null) {
            this.notifyMe.sendFailed(this, e);
        }
        return this.notifyMe != null;
    }

    class RMDeserializer
    extends PJavaSerializedDeserializer {
        MessageDeserializer sub;

        public RMDeserializer() {
            super(null);
        }

        public void setSubDeserializer(MessageDeserializer md) {
            this.sub = md;
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            this.pn = RouteMessage.this.pn;
            return new PastryEndpointMessage(RouteMessage.this.auxAddress, buf, this.sub, type, priority, sender);
        }
    }
}

