/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct.proximitygenerators;

import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.ProximityGenerator;

public class SphereNetworkProximityGenerator
implements ProximityGenerator {
    int maxDiameter;
    RandomSource random;

    public SphereNetworkProximityGenerator(int maxDiameter) {
        this.maxDiameter = maxDiameter;
    }

    public NodeRecord generateNodeRecord() {
        return new SphereNodeRecord();
    }

    public void test() {
        System.out.println(new SphereNodeRecord(0.0, 0.0).proximity(new SphereNodeRecord(0.0, Math.PI)));
        System.out.println(new SphereNodeRecord(-1.0, 0.0).proximity(new SphereNodeRecord(1.0, Math.PI)));
        for (int i = 0; i < 100; ++i) {
            System.out.println(new SphereNodeRecord().proximity(new SphereNodeRecord()));
        }
    }

    public static void main(String[] argz) {
        System.out.println("hello world");
        new SphereNetworkProximityGenerator(Environment.directEnvironment().getParameters().getInt("pastry_direct_max_diameter")).test();
    }

    public void setRandom(RandomSource random) {
        this.random = random;
    }

    private class SphereNodeRecord
    implements NodeRecord {
        public double theta;
        public double phi;
        double radius;

        public SphereNodeRecord() {
            this(Math.asin(2.0 * sphereNetworkProximityGenerator.random.nextDouble() - 1.0), Math.PI * 2 * sphereNetworkProximityGenerator.random.nextDouble());
        }

        public SphereNodeRecord(double theta, double phi) {
            this.theta = theta;
            this.phi = phi;
            this.radius = (double)SphereNetworkProximityGenerator.this.maxDiameter / Math.PI;
        }

        public float proximity(NodeRecord that) {
            return Math.round((double)this.networkDelay(that) * 2.0);
        }

        public float networkDelay(NodeRecord that) {
            SphereNodeRecord nr = (SphereNodeRecord)that;
            double ret = this.radius * Math.acos(Math.cos(this.phi - nr.phi) * Math.cos(this.theta) * Math.cos(nr.theta) + Math.sin(this.theta) * Math.sin(nr.theta));
            if (ret < 2.0 && !this.equals(that)) {
                return 2.0f;
            }
            return (float)ret;
        }

        public void markDead() {
        }
    }
}

