/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct.proximitygenerators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.ProximityGenerator;

public class GenericProximityGenerator
implements ProximityGenerator {
    protected RandomSource random;
    float MIN_DIST = 2.0f;
    private float[][] distance;
    public static int MAXOVERLAYSIZE = 2000;
    public HashMap<Integer, Integer> assignedIndices = new HashMap();
    public File inFile_Matrix;
    int nodesPerStub = 1;
    int numNodes = 0;

    public GenericProximityGenerator(Environment env, File inFile) throws IOException {
        MAXOVERLAYSIZE = env.getParameters().getInt("pastry_direct_gtitm_max_overlay_size");
        this.MIN_DIST = env.getParameters().getFloat("pastry_direct_min_delay");
        float delayFactor = env.getParameters().getFloat("pastry_direct_gtitm_delay_factor");
        this.inFile_Matrix = inFile;
        if (this.inFile_Matrix == null) {
            this.inFile_Matrix = new File(env.getParameters().getString("pastry_direct_gtitm_matrix_file"));
        }
        this.setNodesPerStub(env.getParameters().getInt("pastry_direct_gtitm_nodes_per_stub"));
        this.readOverlayMatrix(delayFactor);
    }

    public NodeRecord generateNodeRecord() {
        return new GNNodeRecord();
    }

    public void setNodesPerStub(int numPerStub) {
        this.nodesPerStub = numPerStub;
    }

    public void readOverlayMatrix(float delayFactor) throws IOException {
        InputStreamReader fr = null;
        try {
            fr = new FileReader(this.inFile_Matrix);
        }
        catch (Exception e) {
            fr.close();
            throw new IOException("ERROR: The required inter-host distance matrix for Generic Network not found:" + this.inFile_Matrix.getAbsolutePath());
        }
        BufferedReader in = new BufferedReader(fr);
        int lineCount = 0;
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                String[] words = line.split("[ \t]+");
                if (this.distance == null) {
                    if (words.length < MAXOVERLAYSIZE) {
                        MAXOVERLAYSIZE = words.length;
                    }
                    this.distance = new float[MAXOVERLAYSIZE][MAXOVERLAYSIZE];
                }
                int nodeCount = 0;
                for (int i = 0; i < MAXOVERLAYSIZE; ++i) {
                    if (words[i].length() <= 0) continue;
                    this.distance[lineCount][nodeCount] = delayFactor * Float.parseFloat(words[i]);
                    if (++nodeCount == MAXOVERLAYSIZE) break;
                }
                if (++lineCount != MAXOVERLAYSIZE) continue;
                break;
            }
            System.out.println("Size of Generic Network matrix= " + lineCount);
        }
        catch (IOException e) {
            System.out.println("Exception" + e);
        }
    }

    private boolean stubIsFull(int index) {
        if (!this.assignedIndices.containsKey(index)) {
            return false;
        }
        return this.assignedIndices.get(index) >= this.nodesPerStub;
    }

    private void incrementStub(int index) {
        ++this.numNodes;
        int val = 0;
        if (this.assignedIndices.containsKey(index)) {
            val = this.assignedIndices.get(index);
        }
        this.assignedIndices.put(index, val + 1);
    }

    private void decrementStub(int index) {
        --this.numNodes;
        int val = this.assignedIndices.get(index);
        this.assignedIndices.put(index, val - 1);
    }

    public void setRandom(RandomSource random) {
        this.random = random;
    }

    public class GNNodeRecord
    implements NodeRecord {
        public int index;

        public GNNodeRecord() {
            if (GenericProximityGenerator.this.numNodes >= MAXOVERLAYSIZE * GenericProximityGenerator.this.nodesPerStub) {
                throw new RuntimeException("No more nodes int he network.");
            }
            this.index = GenericProximityGenerator.this.random.nextInt(MAXOVERLAYSIZE);
            while (GenericProximityGenerator.this.stubIsFull(this.index)) {
                this.index = GenericProximityGenerator.this.random.nextInt(MAXOVERLAYSIZE);
            }
            GenericProximityGenerator.this.incrementStub(this.index);
        }

        public float proximity(NodeRecord that) {
            return Math.round(this.networkDelay(that) + that.networkDelay(this));
        }

        public float networkDelay(NodeRecord that) {
            GNNodeRecord nr = (GNNodeRecord)that;
            float res = GenericProximityGenerator.this.distance[this.index][nr.index];
            if (res < 0.0f) {
                return Float.MAX_VALUE;
            }
            if (res < GenericProximityGenerator.this.MIN_DIST && !this.equals(that)) {
                return GenericProximityGenerator.this.MIN_DIST;
            }
            return res;
        }

        public int getIndex() {
            return this.index;
        }

        public void markDead() {
            GenericProximityGenerator.this.decrementStub(this.index);
        }
    }
}

