/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Map;
import org.mpisws.p2p.transport.direct.Delivery;
import org.mpisws.p2p.transport.direct.DirectTransportLayer;
import rice.environment.logging.Logger;
import rice.pastry.direct.BasicNetworkSimulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageDelivery<Identifier, MessageType>
implements Delivery {
    protected MessageType msg;
    protected Identifier node;
    protected Logger logger;
    protected int seq;
    BasicNetworkSimulator<Identifier, MessageType> networkSimulator;
    Identifier from;
    protected Map<String, Object> options;

    public MessageDelivery(MessageType m, Identifier to, Identifier from, Map<String, Object> options, BasicNetworkSimulator<Identifier, MessageType> sim) {
        this.logger = sim.getTL(to).getLogger();
        this.msg = m;
        this.node = to;
        this.options = options;
        this.from = from;
        this.networkSimulator = sim;
        this.seq = sim.getTL(to).getNextSeq();
        this.logger = sim.getTL(to).getLogger();
    }

    @Override
    public void deliver() {
        block6: {
            if (this.logger.level <= 500) {
                this.logger.log("MD: deliver " + this.msg + " to " + this.node);
            }
            try {
                DirectTransportLayer<Identifier, MessageType> tl = this.networkSimulator.getTL(this.node);
                if (tl != null) {
                    this.networkSimulator.notifySimulatorListenersReceived(this.msg, this.from, this.node);
                    tl.incomingMessage(this.from, this.msg, this.options);
                } else if (this.logger.level <= 900) {
                    this.logger.log("Message " + this.msg + " dropped because destination " + this.node + " is dead.");
                }
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block6;
                this.logger.logException("Error delivering message " + this, ioe);
            }
        }
    }

    @Override
    public int getSeq() {
        return this.seq;
    }

    public String toString() {
        return "MD[" + this.msg + ":" + this.from + "=>" + this.node + ":" + this.seq + "]";
    }
}

