/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.SortedMap;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.NodeHandleSet;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.IdSet;
import rice.pastry.NodeSet;

public class PastryIdFactory
implements IdFactory {
    private MessageDigest md;

    public PastryIdFactory(Environment env) {
        block2: {
            try {
                this.md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                Logger logger = env.getLogManager().getLogger(this.getClass(), null);
                if (logger.level > 1000) break block2;
                logger.log("No SHA support!");
            }
        }
    }

    public rice.p2p.commonapi.Id buildId(byte[] material) {
        return Id.build(material);
    }

    public rice.p2p.commonapi.Id buildId(int[] material) {
        return Id.build(material);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public rice.p2p.commonapi.Id buildId(String string) {
        MessageDigest messageDigest = this.md;
        synchronized (messageDigest) {
            this.md.update(string.getBytes());
            return this.buildId(this.md.digest());
        }
    }

    public rice.p2p.commonapi.Id buildRandomId(Random rng) {
        return Id.makeRandomId(rng);
    }

    public rice.p2p.commonapi.Id buildRandomId(RandomSource rng) {
        return Id.makeRandomId(rng);
    }

    public rice.p2p.commonapi.Id buildIdFromToString(String string) {
        return Id.build(string);
    }

    public rice.p2p.commonapi.Id buildIdFromToString(char[] chars, int offset, int length) {
        return Id.build(chars, offset, length);
    }

    public rice.p2p.commonapi.IdRange buildIdRangeFromPrefix(String string) {
        Id start = Id.build(string);
        Id end = Id.build(string + "ffffffffffffffffffffffffffffffffffffffff");
        end = end.getCW();
        return new IdRange(start, end);
    }

    public int getIdToStringLength() {
        return 40;
    }

    public Id.Distance buildIdDistance(byte[] material) {
        return new Id.Distance(material);
    }

    public rice.p2p.commonapi.IdRange buildIdRange(rice.p2p.commonapi.Id cw, rice.p2p.commonapi.Id ccw) {
        return new IdRange((Id)cw, (Id)ccw);
    }

    public rice.p2p.commonapi.IdSet buildIdSet() {
        return new IdSet();
    }

    public rice.p2p.commonapi.IdSet buildIdSet(SortedMap map) {
        return new IdSet(map);
    }

    public NodeHandleSet buildNodeHandleSet() {
        return new NodeSet();
    }
}

