/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;

public abstract class PastryNodeFactory {
    protected final byte rtMax;
    protected final byte lSetSize;
    protected final byte rtBase;
    protected Environment environment;
    protected Logger logger;

    public PastryNodeFactory(Environment env) {
        this.environment = env;
        this.rtMax = (byte)this.environment.getParameters().getInt("pastry_rtMax");
        this.rtBase = (byte)this.environment.getParameters().getInt("pastry_rtBaseBitLength");
        this.lSetSize = (byte)this.environment.getParameters().getInt("pastry_lSetSize");
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
    }

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode() throws IOException;

    public abstract PastryNode newNode(NodeHandle var1, Id var2);

    public abstract PastryNode newNode(Id var1) throws IOException;

    public Environment getEnvironment() {
        return this.environment;
    }
}

