/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.io.Serializable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;

public class IdRange
implements rice.p2p.commonapi.IdRange,
Serializable {
    private static final long serialVersionUID = -361018850912613915L;
    private boolean empty;
    private Id ccw;
    private Id cw;

    public IdRange(Id ccw, Id cw) {
        this.empty = false;
        this.ccw = ccw;
        this.cw = cw;
    }

    public IdRange() {
        this.empty = true;
        this.cw = this.ccw = Id.build();
    }

    public IdRange(boolean type) {
        this.empty = type;
        this.cw = this.ccw = Id.build();
    }

    public IdRange(IdRange o) {
        this.empty = o.empty;
        this.ccw = o.ccw;
        this.cw = o.cw;
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        if (this.isFull()) {
            return 1;
        }
        return this.ccw.hashCode() ^ this.cw.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdRange)) {
            return false;
        }
        IdRange o = (IdRange)obj;
        if (this.empty && o.empty) {
            return true;
        }
        if (this.isFull() && o.isFull()) {
            return true;
        }
        return this.empty == o.empty && this.ccw.equals(o.ccw) && this.cw.equals(o.cw);
    }

    private Id.Distance size() {
        if (this.ccw.clockwise(this.cw)) {
            return this.ccw.distance(this.cw);
        }
        return this.ccw.longDistance(this.cw);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isFull() {
        return this.ccw.equals(this.cw) && !this.empty;
    }

    public boolean isAdjacent(IdRange o) {
        return (this.ccw.equals(o.cw) || o.ccw.equals(this.cw)) && !this.empty && !o.empty && !this.isFull() && !o.isFull();
    }

    public boolean contains(Id key) {
        if (this.ccw.equals(this.cw) && !this.empty) {
            return true;
        }
        return key.isBetween(this.ccw, this.cw);
    }

    public Id getCCW() {
        return this.ccw;
    }

    public Id getCW() {
        return this.cw;
    }

    public IdRange merge(IdRange o) {
        if (o.empty || this.ccw.equals(this.cw) && !this.empty) {
            return this;
        }
        if (this.empty || o.ccw.equals(o.cw) && !o.empty) {
            return o;
        }
        boolean ccwIn = this.ccw.isBetween(o.ccw, o.cw) || this.ccw.equals(o.cw);
        boolean cwIn = this.cw.isBetween(o.ccw, o.cw);
        boolean occwIn = o.ccw.isBetween(this.ccw, this.cw) || o.ccw.equals(this.cw);
        boolean ocwIn = o.cw.isBetween(this.ccw, this.cw);
        if (ccwIn && cwIn && occwIn && ocwIn) {
            return new IdRange(this.ccw, this.ccw);
        }
        if (ccwIn) {
            if (cwIn) {
                return o;
            }
            return new IdRange(o.ccw, this.cw);
        }
        if (cwIn) {
            return new IdRange(this.ccw, o.cw);
        }
        if (occwIn) {
            return this;
        }
        return this;
    }

    public IdRange complement() {
        if (this.ccw.equals(this.cw) && !this.empty) {
            return new IdRange();
        }
        return new IdRange(this.cw, this.ccw);
    }

    public IdRange intersect(IdRange o) {
        boolean ocwIn;
        if (this.empty || o.empty) {
            return new IdRange();
        }
        if (this.ccw.equals(this.cw)) {
            return o;
        }
        if (o.ccw.equals(o.cw)) {
            return this;
        }
        boolean ccwIn = this.ccw.isBetween(o.ccw, o.cw);
        boolean cwIn = this.cw.isBetween(o.ccw, o.cw) && !this.cw.equals(o.ccw);
        boolean occwIn = o.ccw.isBetween(this.ccw, this.cw);
        boolean bl = ocwIn = o.cw.isBetween(this.ccw, this.cw) && !o.cw.equals(this.ccw);
        if (ccwIn && cwIn && occwIn && ocwIn) {
            return new IdRange(this.ccw, o.cw);
        }
        if (ccwIn) {
            if (cwIn) {
                return this;
            }
            return new IdRange(this.ccw, o.cw);
        }
        if (cwIn) {
            return new IdRange(o.ccw, this.cw);
        }
        if (occwIn) {
            return o;
        }
        return new IdRange();
    }

    public IdRange diff(IdRange o) {
        IdRange res = this.intersect(o.complement());
        if (res.isEmpty()) {
            res = this.complement().intersect(o);
        }
        return res;
    }

    public IdRange subtract(IdRange o, boolean cwPart) {
        if (!cwPart) {
            return this.intersect(o.complement());
        }
        return o.complement().intersect(this);
    }

    public IdRange ccwHalf() {
        if (this.empty) {
            return new IdRange();
        }
        if (this.isFull()) {
            return new IdRange(Id.build(Id.Null), Id.build(Id.Half));
        }
        Id newCW = this.ccw.add(this.size().shift(1, 0, true));
        return new IdRange(this.ccw, newCW);
    }

    public IdRange cwHalf() {
        if (this.empty) {
            return new IdRange();
        }
        if (this.isFull()) {
            return new IdRange(Id.build(Id.Half), Id.build(Id.Null));
        }
        Id newCCW = this.ccw.add(this.size().shift(1, 0, true));
        return new IdRange(newCCW, this.cw);
    }

    public String toString() {
        if (this.empty) {
            return "IdRange: empty";
        }
        return "IdRange: from:" + this.ccw + " to:" + this.cw;
    }

    public boolean containsId(rice.p2p.commonapi.Id key) {
        return this.contains((Id)key);
    }

    public rice.p2p.commonapi.Id getCCWId() {
        return this.getCCW();
    }

    public rice.p2p.commonapi.Id getCWId() {
        return this.getCW();
    }

    public rice.p2p.commonapi.IdRange getComplementRange() {
        return this.complement();
    }

    public rice.p2p.commonapi.IdRange mergeRange(rice.p2p.commonapi.IdRange range) {
        return this.merge((IdRange)range);
    }

    public rice.p2p.commonapi.IdRange diffRange(rice.p2p.commonapi.IdRange range) {
        return this.diff((IdRange)range);
    }

    public rice.p2p.commonapi.IdRange intersectRange(rice.p2p.commonapi.IdRange range) {
        return this.intersect((IdRange)range);
    }

    public IdRange(InputBuffer buf) throws IOException {
        this.cw = Id.build(buf);
        this.ccw = Id.build(buf);
        this.empty = buf.readBoolean();
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.cw.serialize(buf);
        this.ccw.serialize(buf);
        buf.writeBoolean(this.empty);
    }
}

