/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.util.MathUtils;

public class MathUtilsUnit {
    public static void main(String[] args) {
        int n;
        System.out.println("MathUtils Test Suite");
        System.out.println("-------------------------------------------------------------");
        System.out.println("  Running Tests");
        System.out.print("    Testing hexadecimal conversion\t\t\t");
        byte[] testHexBytes = new byte[]{-89, -77, 0, 18, 78};
        String result = MathUtils.toHex(testHexBytes);
        if (result.equals("a7b300124e")) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testHexBytes);
            System.out.println("    Output:\t" + result);
        }
        System.out.print("    Testing long conversion\t\t\t\t");
        long testLong = Long.parseLong("0123456789ABCDEF", 16);
        byte[] testLongByte = MathUtils.longToByteArray(testLong);
        if (testLongByte[0] == 1 && testLongByte[1] == 35 && testLongByte[2] == 69 && testLongByte[3] == 103 && testLongByte[4] == -119 && testLongByte[5] == -85 && testLongByte[6] == -51 && testLongByte[7] == -17) {
            System.out.println("[ PASSED ]");
        } else {
            System.out.println("[ FAILED ]");
            System.out.println("    Input: \t" + testLong);
            System.out.println("    Output:\t" + testLongByte[0] + " " + testLongByte[1] + " " + testLongByte[2] + " " + testLongByte[3]);
        }
        System.out.print("    Testing int->byte[]->int conversion\t\t\t");
        SimpleRandomSource r = new SimpleRandomSource(null);
        boolean passed = true;
        for (n = 0; n < 100000; ++n) {
            int l = r.nextInt();
            byte[] ar = MathUtils.intToByteArray(l);
            int res = MathUtils.byteArrayToInt(ar);
            if (res == l) continue;
            passed = false;
            System.out.println("[ FAILED ]");
            System.out.println("input:  " + l);
            System.out.print("byte[]: ");
            for (int i = 0; i < ar.length; ++i) {
                System.out.print(ar[i] + " ");
            }
            System.out.println();
            System.out.println("output: " + result);
            break;
        }
        if (passed) {
            System.out.println("[ PASSED ]");
        }
        System.out.print("    Testing long->byte[]->long conversion\t\t\t");
        passed = true;
        for (n = 0; n < 100000; ++n) {
            long l = r.nextLong();
            byte[] ar = MathUtils.longToByteArray(l);
            long res = MathUtils.byteArrayToLong(ar);
            if (res == l) continue;
            passed = false;
            System.out.println("[ FAILED ]");
            System.out.println("input:  " + l);
            System.out.print("byte[]: ");
            for (int i = 0; i < ar.length; ++i) {
                System.out.print(ar[i] + " ");
            }
            System.out.println();
            System.out.println("output: " + result);
            break;
        }
        if (passed) {
            System.out.println("[ PASSED ]");
        }
        System.out.println("-------------------------------------------------------------");
    }
}

