/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util.testing;

import java.io.IOException;
import java.util.Iterator;
import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.multiring.MultiringIdFactory;
import rice.p2p.past.gc.GCId;
import rice.p2p.past.gc.GCIdFactory;
import rice.p2p.util.IdBloomFilter;
import rice.pastry.commonapi.PastryIdFactory;

public class IdBloomFilterUnit {
    public static void main(String[] args) throws IOException {
        int n = 300;
        Environment env = new Environment();
        RandomSource random = env.getRandomSource();
        PastryIdFactory pFactory = new PastryIdFactory(env);
        MultiringIdFactory factory = new MultiringIdFactory(pFactory.buildRandomId(random), pFactory);
        GCIdFactory gFactory = new GCIdFactory(factory);
        IdSet set = gFactory.buildIdSet();
        for (int i = 0; i < n; ++i) {
            set.addId(new GCId(factory.buildRandomId(random), System.currentTimeMillis()));
        }
        System.out.println("Start: " + System.currentTimeMillis());
        IdBloomFilter filter = new IdBloomFilter(set);
        System.out.println("Done1: " + System.currentTimeMillis());
        Iterator<Id> i = set.getIterator();
        while (i.hasNext()) {
            if (filter.check(i.next())) continue;
            System.out.println("FAILURE: Element did not exist!");
        }
        System.out.println("Done2: " + System.currentTimeMillis());
        int count = 0;
        for (int j = 0; j < set.numElements(); ++j) {
            if (!filter.check(new GCId(factory.buildRandomId(random), System.currentTimeMillis()))) continue;
            ++count;
        }
        System.out.println("Done3: " + System.currentTimeMillis());
        System.out.println("FALSE POSITIVE RATE: " + count + "/" + set.numElements());
        IdSet set2 = pFactory.buildIdSet();
        Id id = pFactory.buildRandomId(random);
        for (int k = 0; k < 16; ++k) {
            set2.addId(IdBloomFilterUnit.addToId(pFactory, id, k));
        }
        System.out.println("Start: " + System.currentTimeMillis());
        IdBloomFilter filter2 = new IdBloomFilter(set2);
        System.out.println("Done1: " + System.currentTimeMillis());
        Iterator<Id> i2 = set2.getIterator();
        while (i2.hasNext()) {
            if (filter2.check(i2.next())) continue;
            System.out.println("FAILURE: Element did not exist!");
        }
        for (int k = 16; k < 32; ++k) {
            Id id2 = IdBloomFilterUnit.addToId(pFactory, id, k);
            if (!filter2.check(id2)) continue;
            System.out.println("WARNING: Element existed when it probably shouldn't! " + k);
        }
        System.out.println("Done2: " + System.currentTimeMillis());
        env.destroy();
    }

    private static Id addToId(IdFactory FACTORY, Id id, int num) {
        byte[] bytes = id.toByteArray();
        bytes[0] = (byte)(bytes[0] + num);
        return FACTORY.buildId(bytes);
    }
}

