/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import rice.p2p.util.Base64;
import rice.p2p.util.XMLParser;

public class XMLReader {
    protected Reader in;
    protected XmlPullParser xpp;
    protected int eventType;

    public XMLReader(Reader in) throws IOException {
        this.in = new BufferedReader(in);
        try {
            this.xpp = new XMLParser();
            this.xpp.setInput(this.in);
        }
        catch (XmlPullParserException e) {
            throw new IOException("XML Exception thrown: " + (Object)((Object)e));
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public byte[] readBase64() throws IOException {
        byte[] bytes = new byte[]{};
        this.assertStartTag("base64");
        this.step();
        if (this.isText()) {
            bytes = this.xpp.getText().getBytes();
            bytes = Base64.decode(bytes, 0, bytes.length);
            this.step();
        }
        this.assertEndTag("base64");
        return bytes;
    }

    public void readHeader() throws IOException {
        this.assertEvent(0);
        this.readStartTag("jsx");
    }

    protected void assertEvent(int type) throws IOException {
        if (this.eventType != type) {
            throw new IOException("Expected event " + type + ", got a " + this.eventType);
        }
    }

    public void assertStartTag() throws IOException {
        this.assertEvent(2);
    }

    public void assertEndTag() throws IOException {
        this.assertEvent(3);
    }

    public void assertStartTag(String name) throws IOException {
        this.assertStartTag();
        if (!this.xpp.getName().equals(name)) {
            throw new IOException("Expected start tag '" + name + "', got a '" + this.xpp.getName() + "'");
        }
    }

    public void assertEndTag(String name) throws IOException {
        this.assertEvent(3);
        if (!this.xpp.getName().equals(name)) {
            throw new IOException("Expected end tag '" + name + "', got a '" + this.xpp.getName() + "'");
        }
    }

    public void readStartTag() throws IOException {
        this.step();
        this.assertStartTag();
    }

    public void readEndTag() throws IOException {
        this.step();
        this.assertEndTag();
    }

    public void readStartTag(String name) throws IOException {
        this.readStartTag();
        this.assertStartTag(name);
    }

    public void readEndTag(String name) throws IOException {
        this.readEndTag();
        this.assertEndTag(name);
    }

    public void assertAttribute(String name, String value) throws IOException {
        if (this.getAttribute(name) == null) {
            throw new IOException("Expected attribute " + name + ", found none");
        }
        if (!this.getAttribute(name).equals(value)) {
            throw new IOException("Expected attribute " + name + " to be '" + value + "', got '" + this.getAttribute(name) + "'");
        }
    }

    public void step() throws IOException {
        try {
            this.eventType = this.xpp.next();
            if (this.eventType == 4 && this.xpp.isWhitespace()) {
                this.step();
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException("XML Exception thrown: " + (Object)((Object)e));
        }
    }

    public boolean isStartDocument() {
        return this.eventType == 0;
    }

    public boolean isEndDocument() {
        return this.eventType == 1;
    }

    public boolean isStartTag() {
        return this.eventType == 2;
    }

    public boolean isEndTag() {
        return this.eventType == 3;
    }

    public boolean isText() {
        return this.eventType == 4;
    }

    public String getAttribute(String name) throws IOException {
        this.assertEvent(2);
        String result = this.xpp.getAttributeValue(null, name);
        return result;
    }

    public String getStartTag() throws IOException {
        try {
            this.assertEvent(2);
            return this.xpp.getName();
        }
        catch (IOException e) {
            throw new IOException("getStartTag called, caused " + e);
        }
    }

    public String getEndTag() throws IOException {
        try {
            this.assertEvent(3);
            return this.xpp.getName();
        }
        catch (IOException e) {
            throw new IOException("getEndTag called, caused " + e);
        }
    }
}

